/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class User {
    public final String username;
    private final String plainPassword;
    private final String plainMessage;
    private final String hashedPassword;
    private final List<byte[]> encryptedBlocks;
    public int successfulLogins = 0;
    public int failedLogins = 0;
    private long lastFailedTime = 0L;
    private int recentFailures = 0;

    public User(String string, String string2, String string3) {
        this.username = string;
        this.plainPassword = string2;
        this.plainMessage = string3;
        byte[] byArray = User.deriveKeyFromPassword(string2);
        this.hashedPassword = SimpleHasher.hash(string2, string);
        this.encryptedBlocks = User.encryptMessage(string3, byArray);
    }

    public User(String string, String string2, List<byte[]> list) {
        this.username = string;
        this.plainPassword = null;
        this.plainMessage = null;
        this.hashedPassword = string2;
        this.encryptedBlocks = list;
    }

    public boolean checkPassword(String string) {
        String string2 = SimpleHasher.hash(string, this.username);
        return string2.equals(this.hashedPassword);
    }

    public String getDecryptedSecret(String string) {
        byte[] byArray = User.deriveKeyFromPassword(string);
        StringBuilder stringBuilder = new StringBuilder();
        for (byte[] byArray2 : this.encryptedBlocks) {
            byte[] byArray3 = AESdecryption.decrypt(byArray2, byArray);
            stringBuilder.append(new String(byArray3));
        }
        return stringBuilder.toString().trim();
    }

    public boolean isRateLimited() {
        long l = System.currentTimeMillis();
        if (l - this.lastFailedTime > 60000L) {
            this.recentFailures = 0;
        }
        return this.recentFailures >= 3;
    }

    public void recordFailedAttempt() {
        ++this.failedLogins;
        ++this.recentFailures;
        this.lastFailedTime = System.currentTimeMillis();
    }

    public void resetFailures() {
        this.recentFailures = 0;
    }

    public String getPlainPassword() {
        return this.plainPassword;
    }

    public String getPlainMessage() {
        return this.plainMessage;
    }

    public List<byte[]> getEncryptedBlocks() {
        return this.encryptedBlocks;
    }

    private static byte[] deriveKeyFromPassword(String string) {
        return User.padTo16(string.getBytes());
    }

    private static List<byte[]> encryptMessage(String string, byte[] byArray) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        byte[] byArray2 = string.getBytes();
        for (int i = 0; i < byArray2.length; i += 16) {
            byte[] byArray3 = new byte[16];
            int n = Math.min(16, byArray2.length - i);
            System.arraycopy(byArray2, i, byArray3, 0, n);
            arrayList.add(AESencryption.encrypt(byArray3, byArray));
        }
        return arrayList;
    }

    private static byte[] padTo16(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        Arrays.fill(byArray2, (byte)0);
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(16, byArray.length));
        return byArray2;
    }
}

