/*
 * Decompiled with CFR 0.152.
 */
import java.util.concurrent.TimeUnit;

public class TimeoutTimer
extends Thread {
    private int errors = 0;
    private long lockoutUntil = 0L;
    private int[][] timeouts = new int[][]{{5, 1}, {10, 2}, {20, 5}, {50, 10}, {100, 60}};

    public boolean canAttemptLogin() {
        long now = System.currentTimeMillis();
        return now >= this.lockoutUntil;
    }

    public void recordIncorrectAttempt() {
        ++this.errors;
        for (int[] entry : this.timeouts) {
            int threshold = entry[0];
            int minutes = entry[1];
            if (this.errors != threshold) continue;
            long now = System.currentTimeMillis();
            this.lockoutUntil = now + TimeUnit.MINUTES.toMillis(minutes);
            System.out.println("User locked out for " + minutes + " minutes.");
            return;
        }
    }

    public long getRemainingLockoutSeconds() {
        long now = System.currentTimeMillis();
        long diff = this.lockoutUntil - now;
        return diff > 0L ? diff / 1000L : 0L;
    }

    public void reset() {
        this.errors = 0;
        this.lockoutUntil = 0L;
    }
}

