/*
 * Decompiled with CFR 0.152.
 */
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class PasswordHasher {
    private static int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};

    private static int rightRotate(int x, int n) {
        return x >>> n | x << 32 - n;
    }

    private static int choice(int x, int y, int z) {
        return x & y ^ ~x & z;
    }

    private static int majority(int x, int y, int z) {
        return x & y ^ x & z ^ y & z;
    }

    private static int bigSigma0(int x) {
        return PasswordHasher.rightRotate(x, 2) ^ PasswordHasher.rightRotate(x, 13) ^ PasswordHasher.rightRotate(x, 22);
    }

    private static int bigSigma1(int x) {
        return PasswordHasher.rightRotate(x, 6) ^ PasswordHasher.rightRotate(x, 11) ^ PasswordHasher.rightRotate(x, 25);
    }

    private static int smallSigma0(int x) {
        return PasswordHasher.rightRotate(x, 7) ^ PasswordHasher.rightRotate(x, 18) ^ x >>> 3;
    }

    private static int smallSigma1(int x) {
        return PasswordHasher.rightRotate(x, 17) ^ PasswordHasher.rightRotate(x, 19) ^ x >>> 10;
    }

    public static byte[] digest(byte[] message) {
        int[] H = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
        int ml = message.length * 8;
        int remainder = (message.length + 9) % 64;
        int padLen = remainder == 0 ? 0 : 64 - remainder;
        int totalLen = message.length + 1 + padLen + 8;
        byte[] padded = Arrays.copyOf(message, totalLen);
        padded[message.length] = -128;
        for (int i = 0; i < 8; ++i) {
            padded[totalLen - 1 - i] = (byte)(ml >>> 8 * i & 0xFF);
        }
        int[] W = new int[64];
        ByteBuffer buf = ByteBuffer.wrap(padded);
        while (buf.remaining() >= 64) {
            int t;
            for (t = 0; t < 16; ++t) {
                W[t] = buf.getInt();
            }
            for (t = 16; t < 64; ++t) {
                W[t] = PasswordHasher.smallSigma1(W[t - 2]) + W[t - 7] + PasswordHasher.smallSigma0(W[t - 15]) + W[t - 16];
            }
            int a = H[0];
            int b = H[1];
            int c = H[2];
            int d = H[3];
            int e = H[4];
            int f = H[5];
            int g = H[6];
            int h = H[7];
            for (int t2 = 0; t2 < 64; ++t2) {
                int T1 = h + PasswordHasher.bigSigma1(e) + PasswordHasher.choice(e, f, g) + K[t2] + W[t2];
                int T2 = PasswordHasher.bigSigma0(a) + PasswordHasher.majority(a, b, c);
                h = g;
                g = f;
                f = e;
                e = d + T1;
                d = c;
                c = b;
                b = a;
                a = T1 + T2;
            }
            H[0] = H[0] + a;
            H[1] = H[1] + b;
            H[2] = H[2] + c;
            H[3] = H[3] + d;
            H[4] = H[4] + e;
            H[5] = H[5] + f;
            H[6] = H[6] + g;
            H[7] = H[7] + h;
        }
        ByteBuffer out = ByteBuffer.allocate(32);
        for (int hVal : H) {
            out.putInt(hVal);
        }
        return out.array();
    }

    public static String hashHex(String input) {
        byte[] d = PasswordHasher.digest(input.getBytes(StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder(d.length * 2);
        for (byte b : d) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    public static boolean verify(String input, String hash) {
        String hashed = PasswordHasher.hashHex(input);
        return hash.equals(hashed);
    }

    public static void main(String[] args) {
        System.out.println(PasswordHasher.hashHex("Hello world!"));
        System.out.println(PasswordHasher.hashHex("Hello world!"));
        System.out.println(PasswordHasher.hashHex("Hello world!"));
        System.out.println(PasswordHasher.hashHex("Hello world!"));
    }
}

