/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Scanner;

public class Main {
    private static final String[] users = new String[]{"alani1", "garantche2", "guest", "hinkle5", "kent4", "perez10", "rheyne1", "toure3", "wittman1"};
    private static int[][] attempts = new int[][]{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}};
    public static Database database;
    public static TimeoutTimer tm;

    public static void main(String[] args) throws Exception {
        Scanner in = new Scanner(System.in);
        database = new Database();
        tm = new TimeoutTimer();
        while (!Main.handleMenu(in).equals("3")) {
        }
    }

    private static Database loadDatabase() {
        Database database;
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream("database.txt"));
        try {
            Database loadedDb;
            database = loadedDb = (Database)ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
        ois.close();
        return database;
    }

    private static String handleMenu(Scanner in) {
        Main.displayMenu();
        String choice = in.next();
        while (!(choice.equals("1") || choice.equals("2") || choice.equals("3"))) {
            System.out.println("Invalid input.");
            Main.displayMenu();
            choice = in.next();
        }
        switch (choice) {
            case "1": {
                Main.handleLogIn(in);
                System.out.println();
                break;
            }
            case "2": {
                Main.displayAttempts();
                System.out.println();
                break;
            }
            case "3": {
                System.out.println("Exiting...");
            }
        }
        return choice;
    }

    private static void displayMenu() {
        System.out.println("1. Login");
        System.out.println("2. View login table");
        System.out.println("3. Exit");
    }

    private static void handleLogIn(Scanner in) {
        int i;
        if (!tm.canAttemptLogin()) {
            System.out.println("Locked out for " + tm.getRemainingLockoutSeconds() + " seconds.");
            return;
        }
        System.out.print("\nEnter user name: ");
        String userName = in.next();
        System.out.print("Enter password: ");
        String password = in.next();
        boolean verified = false;
        for (i = 0; i < users.length; ++i) {
            if (!users[i].equals(userName)) continue;
            verified = true;
            break;
        }
        if (!verified) {
            System.out.println("No user '" + userName + "' found.");
            return;
        }
        if (!database.verifyPassword(i, password)) {
            System.out.println("Incorrect password.");
            tm.recordIncorrectAttempt();
            int[] nArray = attempts[i];
            nArray[1] = nArray[1] + 1;
            return;
        }
        int[] nArray = attempts[i];
        nArray[0] = nArray[0] + 1;
        System.out.println("Secret Message: " + database.getSecretKey(i, password));
        tm.reset();
    }

    private static void displayAttempts() {
        int userWidth = 15;
        int successWidth = 20;
        int failWidth = 20;
        System.out.printf("%-" + userWidth + "s%-" + successWidth + "s%-" + failWidth + "s%n", "User", "Successful Logins", "Unsuccessful Logins");
        System.out.println("-".repeat(userWidth + successWidth + failWidth));
        for (int i = 0; i < users.length; ++i) {
            System.out.printf("%-" + userWidth + "s%-" + successWidth + "d%-" + failWidth + "d%n", users[i], attempts[i][0], attempts[i][1]);
        }
    }
}

