/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;

public class AES {
    private static final int SIZE = 4;

    public static byte[] encrypt(byte[] fullKey, byte[] message) {
        int padBy = 16 - message.length % 16;
        if (padBy == 16) {
            padBy = 0;
        }
        byte[] padded = Arrays.copyOf(message, message.length + padBy);
        byte[] key = Arrays.copyOfRange(fullKey, 0, 16);
        byte[] result = new byte[padded.length];
        for (int i = 0; i < padded.length / 16; ++i) {
            byte[] block = Arrays.copyOfRange(padded, i * 16, (i + 1) * 16);
            byte[] encrypted = AES.encrypt16(key, block);
            System.arraycopy(encrypted, 0, result, i * 16, 16);
        }
        return result;
    }

    public static byte[] decrypt(byte[] fullKey, byte[] message) {
        byte[] decrypt = Arrays.copyOf(message, message.length);
        byte[] key = Arrays.copyOfRange(fullKey, 0, 16);
        byte[] temp = new byte[decrypt.length];
        int padBy = 0;
        for (int i = 0; i < decrypt.length / 16; ++i) {
            byte[] block = Arrays.copyOfRange(decrypt, i * 16, (i + 1) * 16);
            byte[] decrypted = AES.decrypt16(key, block);
            int j = decrypted.length - 1;
            while (j >= 0 && decrypted[j] == 0) {
                --j;
                ++padBy;
            }
            System.arraycopy(decrypted, 0, temp, i * 16, 16);
        }
        return Arrays.copyOf(temp, temp.length - padBy);
    }

    private static byte[] decrypt16(byte[] key, byte[] message) {
        byte[][] state = new byte[4][4];
        int i = 0;
        for (int c = 0; c < 4; ++c) {
            int r = 0;
            while (r < 4) {
                state[r][c] = message[i];
                ++r;
                ++i;
            }
        }
        byte[][] roundKeys = AES.generateRoundKeys(key);
        AES.addRoundkey(state, roundKeys[10]);
        AES.inverseShiftRows(state);
        AES.inverseSubstituteBytes(state);
        for (i = 9; i >= 1; --i) {
            AES.addRoundkey(state, roundKeys[i]);
            AES.inverseMixColumns(state);
            AES.inverseShiftRows(state);
            AES.inverseSubstituteBytes(state);
        }
        AES.addRoundkey(state, roundKeys[0]);
        byte[] result = new byte[16];
        int i2 = 0;
        for (int c = 0; c < 4; ++c) {
            int r = 0;
            while (r < 4) {
                result[i2] = state[r][c];
                ++r;
                ++i2;
            }
        }
        return result;
    }

    private static byte[] encrypt16(byte[] key, byte[] message) {
        byte[][] state = new byte[4][4];
        int i = 0;
        for (int c = 0; c < 4; ++c) {
            int r = 0;
            while (r < 4) {
                state[r][c] = message[i];
                ++r;
                ++i;
            }
        }
        byte[][] roundKeys = AES.generateRoundKeys(key);
        AES.addRoundkey(state, roundKeys[0]);
        for (i = 1; i < 10; ++i) {
            AES.substituteBytes(state);
            AES.shiftRows(state);
            AES.mixColumns(state);
            AES.addRoundkey(state, roundKeys[i]);
        }
        AES.substituteBytes(state);
        AES.shiftRows(state);
        AES.addRoundkey(state, roundKeys[10]);
        byte[] result = new byte[16];
        int i2 = 0;
        for (int c = 0; c < 4; ++c) {
            int r = 0;
            while (r < 4) {
                result[i2] = state[r][c];
                ++r;
                ++i2;
            }
        }
        return result;
    }

    private static byte[][] generateRoundKeys(byte[] key) {
        byte[][] roundKeys = new byte[11][16];
        roundKeys[0] = Arrays.copyOf(key, 16);
        for (int round = 1; round < 11; ++round) {
            int i;
            byte[] prev = roundKeys[round - 1];
            byte[] current = new byte[16];
            byte[] temp = AES.scheduleCore(Arrays.copyOfRange(prev, 12, 16), round);
            for (i = 0; i < 4; ++i) {
                current[i] = (byte)(prev[i] ^ temp[i]);
            }
            for (i = 4; i < 16; ++i) {
                current[i] = (byte)(prev[i] ^ current[i - 4]);
            }
            roundKeys[round] = current;
        }
        return roundKeys;
    }

    private static byte[] scheduleCore(byte[] bytes, int round) {
        int[] sBox = new int[]{99, 124, 119, 123, 242, 107, 111, 197, 48, 1, 103, 43, 254, 215, 171, 118, 202, 130, 201, 125, 250, 89, 71, 240, 173, 212, 162, 175, 156, 164, 114, 192, 183, 253, 147, 38, 54, 63, 247, 204, 52, 165, 229, 241, 113, 216, 49, 21, 4, 199, 35, 195, 24, 150, 5, 154, 7, 18, 128, 226, 235, 39, 178, 117, 9, 131, 44, 26, 27, 110, 90, 160, 82, 59, 214, 179, 41, 227, 47, 132, 83, 209, 0, 237, 32, 252, 177, 91, 106, 203, 190, 57, 74, 76, 88, 207, 208, 239, 170, 251, 67, 77, 51, 133, 69, 249, 2, 127, 80, 60, 159, 168, 81, 163, 64, 143, 146, 157, 56, 245, 188, 182, 218, 33, 16, 255, 243, 210, 205, 12, 19, 236, 95, 151, 68, 23, 196, 167, 126, 61, 100, 93, 25, 115, 96, 129, 79, 220, 34, 42, 144, 136, 70, 238, 184, 20, 222, 94, 11, 219, 224, 50, 58, 10, 73, 6, 36, 92, 194, 211, 172, 98, 145, 149, 228, 121, 231, 200, 55, 109, 141, 213, 78, 169, 108, 86, 244, 234, 101, 122, 174, 8, 186, 120, 37, 46, 28, 166, 180, 198, 232, 221, 116, 31, 75, 189, 139, 138, 112, 62, 181, 102, 72, 3, 246, 14, 97, 53, 87, 185, 134, 193, 29, 158, 225, 248, 152, 17, 105, 217, 142, 148, 155, 30, 135, 233, 206, 85, 40, 223, 140, 161, 137, 13, 191, 230, 66, 104, 65, 153, 45, 15, 176, 84, 187, 22};
        int[] rCon = new int[]{141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203};
        byte first = bytes[0];
        for (int j = 0; j < bytes.length - 1; ++j) {
            bytes[j] = bytes[j + 1];
        }
        bytes[bytes.length - 1] = first;
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)sBox[bytes[i] & 0xFF];
        }
        bytes[0] = (byte)(bytes[0] ^ (byte)rCon[round]);
        return bytes;
    }

    private static void addRoundkey(byte[][] state, byte[] roundKey) {
        int i = 0;
        for (int c = 0; c < 4; ++c) {
            int r = 0;
            while (r < 4) {
                byte[] byArray = state[r];
                int n = c;
                byArray[n] = (byte)(byArray[n] ^ roundKey[i]);
                ++r;
                ++i;
            }
        }
    }

    private static void shiftRows(byte[][] state) {
        for (int r = 1; r < 4; ++r) {
            byte[] temp = new byte[4];
            for (int c = 0; c < 4; ++c) {
                temp[c] = state[r][(c + r) % 4];
            }
            state[r] = temp;
        }
    }

    private static void substituteBytes(byte[][] state) {
        int[] sBox = new int[]{99, 124, 119, 123, 242, 107, 111, 197, 48, 1, 103, 43, 254, 215, 171, 118, 202, 130, 201, 125, 250, 89, 71, 240, 173, 212, 162, 175, 156, 164, 114, 192, 183, 253, 147, 38, 54, 63, 247, 204, 52, 165, 229, 241, 113, 216, 49, 21, 4, 199, 35, 195, 24, 150, 5, 154, 7, 18, 128, 226, 235, 39, 178, 117, 9, 131, 44, 26, 27, 110, 90, 160, 82, 59, 214, 179, 41, 227, 47, 132, 83, 209, 0, 237, 32, 252, 177, 91, 106, 203, 190, 57, 74, 76, 88, 207, 208, 239, 170, 251, 67, 77, 51, 133, 69, 249, 2, 127, 80, 60, 159, 168, 81, 163, 64, 143, 146, 157, 56, 245, 188, 182, 218, 33, 16, 255, 243, 210, 205, 12, 19, 236, 95, 151, 68, 23, 196, 167, 126, 61, 100, 93, 25, 115, 96, 129, 79, 220, 34, 42, 144, 136, 70, 238, 184, 20, 222, 94, 11, 219, 224, 50, 58, 10, 73, 6, 36, 92, 194, 211, 172, 98, 145, 149, 228, 121, 231, 200, 55, 109, 141, 213, 78, 169, 108, 86, 244, 234, 101, 122, 174, 8, 186, 120, 37, 46, 28, 166, 180, 198, 232, 221, 116, 31, 75, 189, 139, 138, 112, 62, 181, 102, 72, 3, 246, 14, 97, 53, 87, 185, 134, 193, 29, 158, 225, 248, 152, 17, 105, 217, 142, 148, 155, 30, 135, 233, 206, 85, 40, 223, 140, 161, 137, 13, 191, 230, 66, 104, 65, 153, 45, 15, 176, 84, 187, 22};
        for (int c = 0; c < 4; ++c) {
            for (int r = 0; r < 4; ++r) {
                state[r][c] = (byte)sBox[state[r][c] & 0xFF];
            }
        }
    }

    private static void mixColumns(byte[][] state) {
        byte[] a = new byte[4];
        for (int c = 0; c < 4; ++c) {
            for (int r = 0; r < 4; ++r) {
                a[r] = state[r][c];
            }
            state[0][c] = (byte)(AES.galoisMultiply(2, a[0]) ^ AES.galoisMultiply(3, a[1]) ^ a[2] ^ a[3]);
            state[1][c] = (byte)(a[0] ^ AES.galoisMultiply(2, a[1]) ^ AES.galoisMultiply(3, a[2]) ^ a[3]);
            state[2][c] = (byte)(a[0] ^ a[1] ^ AES.galoisMultiply(2, a[2]) ^ AES.galoisMultiply(3, a[3]));
            state[3][c] = (byte)(AES.galoisMultiply(3, a[0]) ^ a[1] ^ a[2] ^ AES.galoisMultiply(2, a[3]));
        }
    }

    private static byte galoisMultiply(int a, int b) {
        int p = 0;
        for (int i = 0; i < 8; ++i) {
            if ((b & 1) == 1) {
                p ^= a;
            }
            int highBit = a & 0x80;
            a <<= 1;
            if (highBit == 128) {
                a ^= 0x1B;
            }
            b >>= 1;
        }
        return (byte)(p &= 0xFF);
    }

    private static void inverseShiftRows(byte[][] state) {
        for (int r = 1; r < 4; ++r) {
            byte[] temp = new byte[4];
            for (int c = 0; c < 4; ++c) {
                temp[(c + r) % 4] = state[r][c];
            }
            state[r] = temp;
        }
    }

    private static void inverseMixColumns(byte[][] state) {
        byte[] a = new byte[4];
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 4; ++i) {
                a[i] = state[i][j];
            }
            state[0][j] = (byte)(AES.galoisMultiply(a[0], 14) ^ AES.galoisMultiply(a[3], 9) ^ AES.galoisMultiply(a[2], 13) ^ AES.galoisMultiply(a[1], 11));
            state[1][j] = (byte)(AES.galoisMultiply(a[1], 14) ^ AES.galoisMultiply(a[0], 9) ^ AES.galoisMultiply(a[3], 13) ^ AES.galoisMultiply(a[2], 11));
            state[2][j] = (byte)(AES.galoisMultiply(a[2], 14) ^ AES.galoisMultiply(a[1], 9) ^ AES.galoisMultiply(a[0], 13) ^ AES.galoisMultiply(a[3], 11));
            state[3][j] = (byte)(AES.galoisMultiply(a[3], 14) ^ AES.galoisMultiply(a[2], 9) ^ AES.galoisMultiply(a[1], 13) ^ AES.galoisMultiply(a[0], 11));
        }
    }

    private static void inverseSubstituteBytes(byte[][] state) {
        int[] sBox = new int[]{82, 9, 106, 213, 48, 54, 165, 56, 191, 64, 163, 158, 129, 243, 215, 251, 124, 227, 57, 130, 155, 47, 255, 135, 52, 142, 67, 68, 196, 222, 233, 203, 84, 123, 148, 50, 166, 194, 35, 61, 238, 76, 149, 11, 66, 250, 195, 78, 8, 46, 161, 102, 40, 217, 36, 178, 118, 91, 162, 73, 109, 139, 209, 37, 114, 248, 246, 100, 134, 104, 152, 22, 212, 164, 92, 204, 93, 101, 182, 146, 108, 112, 72, 80, 253, 237, 185, 218, 94, 21, 70, 87, 167, 141, 157, 132, 144, 216, 171, 0, 140, 188, 211, 10, 247, 228, 88, 5, 184, 179, 69, 6, 208, 44, 30, 143, 202, 63, 15, 2, 193, 175, 189, 3, 1, 19, 138, 107, 58, 145, 17, 65, 79, 103, 220, 234, 151, 242, 207, 206, 240, 180, 230, 115, 150, 172, 116, 34, 231, 173, 53, 133, 226, 249, 55, 232, 28, 117, 223, 110, 71, 241, 26, 113, 29, 41, 197, 137, 111, 183, 98, 14, 170, 24, 190, 27, 252, 86, 62, 75, 198, 210, 121, 32, 154, 219, 192, 254, 120, 205, 90, 244, 31, 221, 168, 51, 136, 7, 199, 49, 177, 18, 16, 89, 39, 128, 236, 95, 96, 81, 127, 169, 25, 181, 74, 13, 45, 229, 122, 159, 147, 201, 156, 239, 160, 224, 59, 77, 174, 42, 245, 176, 200, 235, 187, 60, 131, 83, 153, 97, 23, 43, 4, 126, 186, 119, 214, 38, 225, 105, 20, 99, 85, 33, 12, 125};
        for (int c = 0; c < 4; ++c) {
            for (int r = 0; r < 4; ++r) {
                state[r][c] = (byte)sBox[state[r][c] & 0xFF];
            }
        }
    }

    private static void printRoundKeys(byte[][] roundKeys) {
        for (int i = 0; i < roundKeys.length; ++i) {
            System.out.print("Round " + i + ": ");
            for (int b = 0; b < 16; ++b) {
                System.out.format("%02X, ", roundKeys[i][b]);
            }
            System.out.println();
        }
    }

    private static void printState(byte[][] state) {
        for (int r = 0; r < 4; ++r) {
            System.out.print("[");
            for (int c = 0; c < 4; ++c) {
                System.out.format("%02X ", state[r][c]);
            }
            System.out.println("]");
        }
    }
}

