/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;

public class otherAES {
    private static final int[] sBox = new int[]{99, 124, 119, 123, 242, 107, 111, 197, 48, 1, 103, 43, 254, 215, 171, 118, 202, 130, 201, 125, 250, 89, 71, 240, 173, 212, 162, 175, 156, 164, 114, 192, 183, 253, 147, 38, 54, 63, 247, 204, 52, 165, 229, 241, 113, 216, 49, 21, 4, 199, 35, 195, 24, 150, 5, 154, 7, 18, 128, 226, 235, 39, 178, 117, 9, 131, 44, 26, 27, 110, 90, 160, 82, 59, 214, 179, 41, 227, 47, 132, 83, 209, 0, 237, 32, 252, 177, 91, 106, 203, 190, 57, 74, 76, 88, 207, 208, 239, 170, 251, 67, 77, 51, 133, 69, 249, 2, 127, 80, 60, 159, 168, 81, 163, 64, 143, 146, 157, 56, 245, 188, 182, 218, 33, 16, 255, 243, 210, 205, 12, 19, 236, 95, 151, 68, 23, 196, 167, 126, 61, 100, 93, 25, 115, 96, 129, 79, 220, 34, 42, 144, 136, 70, 238, 184, 20, 222, 94, 11, 219, 224, 50, 58, 10, 73, 6, 36, 92, 194, 211, 172, 98, 145, 149, 228, 121, 231, 200, 55, 109, 141, 213, 78, 169, 108, 86, 244, 234, 101, 122, 174, 8, 186, 120, 37, 46, 28, 166, 180, 198, 232, 221, 116, 31, 75, 189, 139, 138, 112, 62, 181, 102, 72, 3, 246, 14, 97, 53, 87, 185, 134, 193, 29, 158, 225, 248, 152, 17, 105, 217, 142, 148, 155, 30, 135, 233, 206, 85, 40, 223, 140, 161, 137, 13, 191, 230, 66, 104, 65, 153, 45, 15, 176, 84, 187, 22};
    private static final int[] inverseBox = new int[]{82, 9, 106, 213, 48, 54, 165, 56, 191, 64, 163, 158, 129, 243, 215, 251, 124, 227, 57, 130, 155, 47, 255, 135, 52, 142, 67, 68, 196, 222, 233, 203, 84, 123, 148, 50, 166, 194, 35, 61, 238, 76, 149, 11, 66, 250, 195, 78, 8, 46, 161, 102, 40, 217, 36, 178, 118, 91, 162, 73, 109, 139, 209, 37, 114, 248, 246, 100, 134, 104, 152, 22, 212, 164, 92, 204, 93, 101, 182, 146, 108, 112, 72, 80, 253, 237, 185, 218, 94, 21, 70, 87, 167, 141, 157, 132, 144, 216, 171, 0, 140, 188, 211, 10, 247, 228, 88, 5, 184, 179, 69, 6, 208, 44, 30, 143, 202, 63, 15, 2, 193, 175, 189, 3, 1, 19, 138, 107, 58, 145, 17, 65, 79, 103, 220, 234, 151, 242, 207, 206, 240, 180, 230, 115, 150, 172, 116, 34, 231, 173, 53, 133, 226, 249, 55, 232, 28, 117, 223, 110, 71, 241, 26, 113, 29, 41, 197, 137, 111, 183, 98, 14, 170, 24, 190, 27, 252, 86, 62, 75, 198, 210, 121, 32, 154, 219, 192, 254, 120, 205, 90, 244, 31, 221, 168, 51, 136, 7, 199, 49, 177, 18, 16, 89, 39, 128, 236, 95, 96, 81, 127, 169, 25, 181, 74, 13, 45, 229, 122, 159, 147, 201, 156, 239, 160, 224, 59, 77, 174, 42, 245, 176, 200, 235, 187, 60, 131, 83, 153, 97, 23, 43, 4, 126, 186, 119, 214, 38, 225, 105, 20, 99, 85, 33, 12, 125};
    private static final int[] rcon = new int[]{141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203};

    public static byte[] encrypt(byte[] plainText, User user) {
        byte[] key = KeyMaker.maker(user.getPassword());
        byte[] cipherBytes = new byte[plainText.length + (16 - plainText.length % 16)];
        for (int i = 0; i < cipherBytes.length; i += 16) {
            byte[][] encryptedBlock = otherAES.encryption(key, Arrays.copyOfRange(plainText, i, i + 16));
            System.arraycopy(otherAES.getByteArray(encryptedBlock), 0, cipherBytes, i, 16);
        }
        return cipherBytes;
    }

    public static byte[] decrypt(byte[] cipherBytes, User user) {
        byte[] key = KeyMaker.maker(user.getPassword());
        byte[] decryptedBytes = new byte[cipherBytes.length];
        for (int i = 0; i < decryptedBytes.length; i += 16) {
            int end = Math.min(i + 16, cipherBytes.length);
            byte[][] decryptedBlock = otherAES.decryption(key, Arrays.copyOfRange(cipherBytes, i, end));
            System.arraycopy(otherAES.getByteArray(decryptedBlock), 0, decryptedBytes, i, end - i);
        }
        int trimIndex = decryptedBytes.length;
        boolean done = false;
        for (int i = decryptedBytes.length - 1; i >= 0 && !done; --i) {
            if (decryptedBytes[i] == 0) {
                trimIndex = i;
                continue;
            }
            done = true;
        }
        decryptedBytes = Arrays.copyOfRange(decryptedBytes, 0, trimIndex);
        return decryptedBytes;
    }

    private static byte[] xorByteArrays(byte[] array1, byte[] array2) {
        byte[] result = new byte[array1.length];
        for (int i = 0; i < array1.length; ++i) {
            result[i] = (byte)(array1[i] ^ array2[i]);
        }
        return result;
    }

    private static byte[] getByteArray(byte[][] state) {
        byte[] array = new byte[state.length * state.length];
        int index = 0;
        for (int column = 0; column < state.length; ++column) {
            for (int row = 0; row < state.length; ++row) {
                array[index++] = state[row][column];
            }
        }
        return array;
    }

    private static byte[] getRoundKey(byte[] previous, int round) {
        int i;
        byte[] zero = Arrays.copyOfRange(previous, 0, 4);
        byte[] one = Arrays.copyOfRange(previous, 4, 8);
        byte[] two = Arrays.copyOfRange(previous, 8, 12);
        byte[] three = Arrays.copyOfRange(previous, 12, 16);
        byte[] temp = Arrays.copyOf(three, 4);
        byte last = temp[0];
        for (i = 0; i < temp.length - 1; ++i) {
            temp[i] = temp[i + 1];
        }
        temp[temp.length - 1] = last;
        for (i = 0; i < temp.length; ++i) {
            temp[i] = (byte)sBox[temp[i] & 0xFF];
        }
        temp[0] = (byte)(temp[0] ^ (byte)rcon[round]);
        byte[] four = otherAES.xorByteArrays(zero, temp);
        byte[] five = otherAES.xorByteArrays(four, one);
        byte[] six = otherAES.xorByteArrays(five, two);
        byte[] seven = otherAES.xorByteArrays(six, three);
        byte[] roundKey = new byte[16];
        System.arraycopy(four, 0, roundKey, 0, 4);
        System.arraycopy(five, 0, roundKey, 4, 4);
        System.arraycopy(six, 0, roundKey, 8, 4);
        System.arraycopy(seven, 0, roundKey, 12, 4);
        return roundKey;
    }

    private static void addRoundKey(byte[][] state, byte[] roundKey) {
        int index = 0;
        for (int column = 0; column < state.length; ++column) {
            for (int row = 0; row < state.length; ++row) {
                byte[] byArray = state[row];
                int n = column;
                byArray[n] = (byte)(byArray[n] ^ roundKey[index++]);
            }
        }
    }

    private static void substituteBytes(byte[][] state) {
        for (int row = 0; row < state.length; ++row) {
            for (int column = 0; column < state.length; ++column) {
                state[row][column] = (byte)sBox[state[row][column] & 0xFF];
            }
        }
    }

    private static void shiftRows(byte[][] state) {
        for (int row = 1; row < state.length; ++row) {
            byte[] temp = new byte[state.length];
            for (int column = 0; column < state.length; ++column) {
                temp[column] = state[row][(column + row) % state.length];
            }
            System.arraycopy(temp, 0, state[row], 0, state.length);
        }
    }

    private static void mixColumns(byte[][] state) {
        byte[] a = new byte[4];
        for (int j = 0; j < state.length; ++j) {
            for (int i = 0; i < state.length; ++i) {
                a[i] = state[i][j];
            }
            state[0][j] = (byte)(otherAES.galoisMultiply(a[0], 2) ^ otherAES.galoisMultiply(a[1], 3) ^ a[2] ^ a[3]);
            state[1][j] = (byte)(a[0] ^ otherAES.galoisMultiply(a[1], 2) ^ otherAES.galoisMultiply(a[2], 3) ^ a[3]);
            state[2][j] = (byte)(a[0] ^ a[1] ^ otherAES.galoisMultiply(a[2], 2) ^ otherAES.galoisMultiply(a[3], 3));
            state[3][j] = (byte)(otherAES.galoisMultiply(a[0], 3) ^ a[1] ^ a[2] ^ otherAES.galoisMultiply(a[3], 2));
        }
    }

    private static void inverseMixColumns(byte[][] state) {
        byte[] a = new byte[4];
        for (int j = 0; j < state.length; ++j) {
            for (int i = 0; i < state.length; ++i) {
                a[i] = state[i][j];
            }
            state[0][j] = (byte)(otherAES.galoisMultiply(a[0], 14) ^ otherAES.galoisMultiply(a[3], 9) ^ otherAES.galoisMultiply(a[2], 13) ^ otherAES.galoisMultiply(a[1], 11));
            state[1][j] = (byte)(otherAES.galoisMultiply(a[1], 14) ^ otherAES.galoisMultiply(a[0], 9) ^ otherAES.galoisMultiply(a[3], 13) ^ otherAES.galoisMultiply(a[2], 11));
            state[2][j] = (byte)(otherAES.galoisMultiply(a[2], 14) ^ otherAES.galoisMultiply(a[1], 9) ^ otherAES.galoisMultiply(a[0], 13) ^ otherAES.galoisMultiply(a[3], 11));
            state[3][j] = (byte)(otherAES.galoisMultiply(a[3], 14) ^ otherAES.galoisMultiply(a[2], 9) ^ otherAES.galoisMultiply(a[1], 13) ^ otherAES.galoisMultiply(a[0], 11));
        }
    }

    private static byte galoisMultiply(int a, int b) {
        int p = 0;
        for (int i = 0; i < 8; ++i) {
            if ((b & 1) == 1) {
                p ^= a;
            }
            int highBit = a & 0x80;
            a <<= 1;
            if (highBit == 128) {
                a ^= 0x1B;
            }
            b >>= 1;
        }
        return (byte)(p &= 0xFF);
    }

    private static byte[][] loadState(byte[] plaintext) {
        byte[][] state = new byte[4][4];
        int index = 0;
        for (int column = 0; column < state.length; ++column) {
            for (int row = 0; row < state.length; ++row) {
                state[row][column] = plaintext[index++];
            }
        }
        return state;
    }

    private static byte[][] encryption(byte[] key, byte[] plaintext) {
        int i;
        byte[][] state = otherAES.loadState(plaintext);
        byte[][] roundKeys = new byte[11][16];
        roundKeys[0] = key;
        for (i = 1; i <= roundKeys.length - 1; ++i) {
            roundKeys[i] = otherAES.getRoundKey(roundKeys[i - 1], i);
        }
        otherAES.addRoundKey(state, roundKeys[0]);
        for (i = 1; i <= 9; ++i) {
            otherAES.substituteBytes(state);
            otherAES.shiftRows(state);
            otherAES.mixColumns(state);
            otherAES.addRoundKey(state, roundKeys[i]);
        }
        otherAES.substituteBytes(state);
        otherAES.shiftRows(state);
        otherAES.addRoundKey(state, roundKeys[10]);
        return state;
    }

    private static byte[][] decryption(byte[] key, byte[] ciphertext) {
        int i;
        byte[][] state = otherAES.loadState(ciphertext);
        byte[][] roundKeys = new byte[11][16];
        roundKeys[0] = key;
        for (i = 1; i <= roundKeys.length - 1; ++i) {
            roundKeys[i] = otherAES.getRoundKey(roundKeys[i - 1], i);
        }
        otherAES.addRoundKey(state, roundKeys[10]);
        otherAES.inverseShiftRows(state);
        otherAES.inverseSubstituteBytes(state);
        for (i = 9; i >= 1; --i) {
            otherAES.addRoundKey(state, roundKeys[i]);
            otherAES.inverseMixColumns(state);
            otherAES.inverseShiftRows(state);
            otherAES.inverseSubstituteBytes(state);
        }
        otherAES.addRoundKey(state, roundKeys[0]);
        return state;
    }

    private static void inverseShiftRows(byte[][] state) {
        for (int row = 0; row < state.length; ++row) {
            byte[] temp = new byte[state.length];
            for (int column = 0; column < state.length; ++column) {
                temp[column] = state[row][(column - row + state.length) % state.length];
            }
            System.arraycopy(temp, 0, state[row], 0, state.length);
        }
    }

    private static void inverseSubstituteBytes(byte[][] state) {
        for (int row = 0; row < state.length; ++row) {
            for (int column = 0; column < state.length; ++column) {
                state[row][column] = (byte)inverseBox[state[row][column] & 0xFF];
            }
        }
    }
}

