/*
 * Decompiled with CFR 0.152.
 */
public class Hash {
    private static final long[] RC = new long[]{1L, 32898L, -9223372036854742902L, -9223372034707259392L, 32907L, 0x80000001L, -9223372034707259263L, -9223372036854743031L, 138L, 136L, 0x80008009L, 0x8000000AL, 0x8000808BL, -9223372036854775669L, -9223372036854742903L, -9223372036854743037L, -9223372036854743038L, -9223372036854775680L, 32778L, -9223372034707292150L, -9223372034707259263L, -9223372036854742912L, 0x80000001L, -9223372034707259384L};
    private static final int[][] ROT = new int[][]{{0, 36, 3, 41, 18}, {1, 44, 10, 45, 2}, {62, 6, 43, 15, 61}, {28, 55, 25, 21, 56}, {27, 20, 39, 8, 14}};

    public static byte[] hash(byte[] message) {
        byte[] padded = Hash.pad(message);
        long[] messageLong = Hash.byteToLong(padded);
        long[][] state = new long[5][5];
        for (int i = 0; i < messageLong.length; i += 9) {
            long[] block = new long[9];
            System.arraycopy(messageLong, i, block, 0, 9);
            Hash.hash(state, block);
        }
        return Hash.squeeze(state);
    }

    private static void hash(long[][] state, long[] message) {
        Hash.loadState(state, message);
        for (int i = 0; i < 24; ++i) {
            Hash.theta(state);
            Hash.chi(state, Hash.rhoAndPhi(state));
            Hash.iota(state, i);
        }
    }

    private static void theta(long[][] state) {
        int x;
        long[] c = new long[5];
        long[] d = new long[5];
        for (x = 0; x < state.length; ++x) {
            long temp;
            c[x] = temp = state[x][0] ^ state[x][1] ^ state[x][2] ^ state[x][3] ^ state[x][4];
        }
        for (x = 0; x < 5; ++x) {
            d[x] = c[(x + 4) % 5] ^ Long.rotateLeft(c[(x + 1) % 5], 1);
        }
        for (x = 0; x < state.length; ++x) {
            for (int y = 0; y < state.length; ++y) {
                state[x][y] = state[x][y] ^ d[x];
            }
        }
    }

    private static long[][] rhoAndPhi(long[][] state) {
        long[][] B = new long[5][5];
        for (int x = 0; x < 5; ++x) {
            for (int y = 0; y < 5; ++y) {
                B[y][(2 * x + 3 * y) % 5] = Long.rotateLeft(state[x][y], ROT[x][y]);
            }
        }
        return B;
    }

    private static void chi(long[][] state, long[][] b) {
        for (int x = 0; x < 5; ++x) {
            for (int y = 0; y < 5; ++y) {
                state[x][y] = b[x][y] ^ (b[(x + 1) % 5][y] ^ 0xFFFFFFFFFFFFFFFFL) & b[(x + 2) % 5][y];
            }
        }
    }

    private static void iota(long[][] state, int round) {
        long[] lArray = state[0];
        lArray[0] = lArray[0] ^ RC[round];
    }

    private static byte[] pad(byte[] message) {
        int size = message.length * 8;
        int pad = 576 - (size + 2) % 576;
        byte[] newMess = new byte[(size += 2 + pad) / 8];
        System.arraycopy(message, 0, newMess, 0, message.length);
        newMess[message.length] = 6;
        newMess[newMess.length - 1] = -128;
        return newMess;
    }

    private static void loadState(long[][] state, long[] message) {
        int index = 0;
        for (int y = 0; y < state.length; ++y) {
            for (int x = 0; x < state.length; ++x) {
                if (index >= message.length) continue;
                state[x][y] = state[x][y] ^ message[index];
                ++index;
            }
        }
    }

    private static long[] byteToLong(byte[] message) {
        long[] messageLong = new long[message.length / 8];
        int index = 0;
        for (int i = 0; i < messageLong.length; ++i) {
            long lane = 0L;
            for (int b = 0; b < 8; ++b) {
                lane |= ((long)message[index] & 0xFFL) << 8 * b;
                ++index;
            }
            messageLong[i] = lane;
        }
        return messageLong;
    }

    private static byte[] squeeze(long[][] state) {
        byte[] output = new byte[64];
        int index = 0;
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                long lane = state[x][y];
                if (index >= 64) continue;
                for (int b = 0; b < 8; ++b) {
                    output[index] = (byte)(lane >>> 8 * b & 0xFFL);
                    ++index;
                }
            }
        }
        return output;
    }

    public static byte[] comp() {
        byte[] numbers = new byte[]{91, -14, 6, 55, 120, -77, 23, 45, -9};
        byte[] compNumbers = new byte[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            int x = numbers[i];
            x = (int)Long.rotateLeft(x, i % 7);
            compNumbers[i] = (byte)(x ^= i * 33 + 19);
        }
        return compNumbers;
    }
}

