/*
 * Decompiled with CFR 0.152.
 */
class SHA256 {
    final int BYTES_PER_ROW = 4;
    private final int BITS_PER_BYTE = 8;
    private static final int PRE_PADDING_BITS = 448;
    private static final int TOTAL_BITS = 512;
    private static final int BITS_PER_ROW = 32;
    private static final int NUM_ROWS = 16;
    private static final int NUM_WORDS = 64;
    private static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private static final int[] H = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};

    SHA256() {
    }

    private byte[][] passwordToBinary(String string) {
        byte[][] byArray = new byte[16][32];
        for (int i = 0; i < string.length() && i < 64; ++i) {
            int n = i / 4;
            int n2 = i % 4 * 8;
            char c = string.charAt(i);
            for (int j = 0; j < 8; ++j) {
                byArray[n][n2 + (7 - j)] = (byte)(c >> j & 1);
            }
        }
        return byArray;
    }

    private byte[][] paddingPassword(byte[][] byArray, int n) {
        int n2 = n * 8;
        int n3 = n2 / 32;
        byArray[n3][n2 %= 32] = 1;
        n2 = 0;
        String string = Integer.toBinaryString(n * 8);
        for (n3 = 32 - string.length(); n3 < 32; ++n3) {
            byArray[15][n3] = (byte)(string.charAt(n2++) - 48);
        }
        return byArray;
    }

    private byte[] smallSigma(byte[] byArray, boolean bl) {
        int n;
        int n2 = bl ? 7 : 17;
        int n3 = bl ? 18 : 19;
        int n4 = bl ? 3 : 10;
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[32];
        for (n = 0; n < 32; ++n) {
            byArray2[(n + n2) % 32] = byArray[n];
        }
        for (n = 0; n < 32; ++n) {
            byArray3[(n + n3) % 32] = byArray[n];
        }
        for (n = 31; n >= 0; --n) {
            n2 = n - n4;
            byArray4[n] = n2 >= 0 ? byArray[n2] : (byte)0;
        }
        for (n = 0; n < 32; ++n) {
            byArray5[n] = (byte)(byArray2[n] ^ byArray3[n] ^ byArray4[n]);
        }
        return byArray5;
    }

    private byte[] bigSigma(byte[] byArray, boolean bl) {
        int n;
        int n2 = bl ? 2 : 6;
        int n3 = bl ? 13 : 11;
        int n4 = bl ? 22 : 25;
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[32];
        for (n = 0; n < 32; ++n) {
            byArray2[(n + n2) % 32] = byArray[n];
            byArray3[(n + n3) % 32] = byArray[n];
            byArray4[(n + n4) % 32] = byArray[n];
        }
        for (n = 0; n < 32; ++n) {
            byArray5[n] = (byte)(byArray2[n] ^ byArray3[n] ^ byArray4[n]);
        }
        return byArray5;
    }

    private byte[] chooseByteFunction(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[32];
        for (int i = 0; i < 32; ++i) {
            byArray4[i] = byArray[i] == 1 ? byArray2[i] : byArray3[i];
        }
        return byArray4;
    }

    private byte[] majorityFunction(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[32];
        for (int i = 0; i < 32; ++i) {
            byArray4[i] = (byte)(byArray[i] & byArray2[i] ^ byArray[i] & byArray3[i] ^ byArray2[i] & byArray3[i]);
        }
        return byArray4;
    }

    private static byte[] intToBitArray(int n) {
        byte[] byArray = new byte[32];
        for (int i = 0; i < 32; ++i) {
            byArray[i] = (byte)(n >> 31 - i & 1);
        }
        return byArray;
    }

    private byte[][] expandWord(byte[][] byArray) {
        byte[][] byArray2 = new byte[64][32];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        for (int i = 16; i < 64; ++i) {
            byte[] byArray3 = this.smallSigma(byArray2[i - 15], true);
            byte[] byArray4 = this.smallSigma(byArray2[i - 2], false);
            for (int j = 0; j < 32; ++j) {
                byArray2[i][j] = (byte)(byArray4[j] ^ byArray2[i - 7][j] ^ byArray3[j] ^ byArray2[i - 16][j]);
            }
        }
        return byArray2;
    }

    protected String digest(String object) {
        Object object2;
        Object object3;
        byte[] byArray = SHA256.intToBitArray(H[0]);
        byte[] byArray2 = SHA256.intToBitArray(H[1]);
        byte[] byArray3 = SHA256.intToBitArray(H[2]);
        byte[] byArray4 = SHA256.intToBitArray(H[3]);
        byte[] byArray5 = SHA256.intToBitArray(H[4]);
        byte[] byArray6 = SHA256.intToBitArray(H[5]);
        byte[] byArray7 = SHA256.intToBitArray(H[6]);
        byte[] byArray8 = SHA256.intToBitArray(H[7]);
        Object object4 = this.passwordToBinary((String)object);
        object = this.paddingPassword((byte[][])object4, ((String)object).length());
        object = this.expandWord((byte[][])object);
        object4 = new byte[32];
        byte[] byArray9 = new byte[32];
        for (int i = 0; i < 64; ++i) {
            int n;
            object3 = SHA256.intToBitArray(K[i]);
            byte[] byArray10 = this.bigSigma(byArray5, false);
            object2 = this.chooseByteFunction(byArray5, byArray6, byArray7);
            byte[] byArray11 = this.bigSigma(byArray, true);
            byte[] byArray12 = this.majorityFunction(byArray, byArray2, byArray3);
            for (n = 0; n < 32; ++n) {
                object4[n] = (byte[])((byte)(byArray8[n] ^ byArray10[n] ^ object2[n] ^ object3[n] ^ object[i][n]));
            }
            for (n = 0; n < 32; ++n) {
                byArray9[n] = (byte)(byArray11[n] ^ byArray12[n]);
            }
            byArray8 = byArray7;
            byArray7 = byArray6;
            byArray6 = byArray5;
            for (n = 0; n < 32; ++n) {
                byArray5[n] = (byte)(byArray4[n] ^ object4[n]);
            }
            byArray4 = byArray3;
            byArray3 = byArray2;
            byArray2 = byArray;
            for (n = 0; n < 32; ++n) {
                byArray[n] = (byte)(object4[n] ^ byArray9[n]);
            }
        }
        byte[][] byArray13 = new byte[8][32];
        object3 = new byte[][]{byArray, byArray2, byArray3, byArray4, byArray5, byArray6, byArray7, byArray8};
        for (int i = 0; i < 8; ++i) {
            object2 = SHA256.intToBitArray(H[i]);
            for (int j = 0; j < 32; ++j) {
                byArray13[i][j] = (byte)(object3[i][j] ^ object2[j]);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        object2 = byArray13;
        int n = byArray13.length;
        for (int i = 0; i < n; ++i) {
            byte by = object2[i];
            for (int j = 0; j < 4; ++j) {
                int n2 = 0;
                for (int k = 0; k < 8; ++k) {
                    n2 = n2 << 1 | by[j * 8 + k] & 1;
                }
                stringBuilder.append(String.format("%02x", n2));
            }
        }
        return stringBuilder.toString();
    }
}

