/*
 * Decompiled with CFR 0.152.
 */
class Decryption {
    byte[] key;
    public static final int MATRIX_LEN = 4;
    private static final int NUM_ROUNDS = 10;
    private static final int WORDS_IN_KEY = 4;
    private static final int KEY_LENGTH = 16;
    private static final int[] RCON = new int[]{141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203};
    private static final int[] S_BOX = new int[]{99, 124, 119, 123, 242, 107, 111, 197, 48, 1, 103, 43, 254, 215, 171, 118, 202, 130, 201, 125, 250, 89, 71, 240, 173, 212, 162, 175, 156, 164, 114, 192, 183, 253, 147, 38, 54, 63, 247, 204, 52, 165, 229, 241, 113, 216, 49, 21, 4, 199, 35, 195, 24, 150, 5, 154, 7, 18, 128, 226, 235, 39, 178, 117, 9, 131, 44, 26, 27, 110, 90, 160, 82, 59, 214, 179, 41, 227, 47, 132, 83, 209, 0, 237, 32, 252, 177, 91, 106, 203, 190, 57, 74, 76, 88, 207, 208, 239, 170, 251, 67, 77, 51, 133, 69, 249, 2, 127, 80, 60, 159, 168, 81, 163, 64, 143, 146, 157, 56, 245, 188, 182, 218, 33, 16, 255, 243, 210, 205, 12, 19, 236, 95, 151, 68, 23, 196, 167, 126, 61, 100, 93, 25, 115, 96, 129, 79, 220, 34, 42, 144, 136, 70, 238, 184, 20, 222, 94, 11, 219, 224, 50, 58, 10, 73, 6, 36, 92, 194, 211, 172, 98, 145, 149, 228, 121, 231, 200, 55, 109, 141, 213, 78, 169, 108, 86, 244, 234, 101, 122, 174, 8, 186, 120, 37, 46, 28, 166, 180, 198, 232, 221, 116, 31, 75, 189, 139, 138, 112, 62, 181, 102, 72, 3, 246, 14, 97, 53, 87, 185, 134, 193, 29, 158, 225, 248, 152, 17, 105, 217, 142, 148, 155, 30, 135, 233, 206, 85, 40, 223, 140, 161, 137, 13, 191, 230, 66, 104, 65, 153, 45, 15, 176, 84, 187, 22};
    private static final int[] I_S_BOX = new int[]{82, 9, 106, 213, 48, 54, 165, 56, 191, 64, 163, 158, 129, 243, 215, 251, 124, 227, 57, 130, 155, 47, 255, 135, 52, 142, 67, 68, 196, 222, 233, 203, 84, 123, 148, 50, 166, 194, 35, 61, 238, 76, 149, 11, 66, 250, 195, 78, 8, 46, 161, 102, 40, 217, 36, 178, 118, 91, 162, 73, 109, 139, 209, 37, 114, 248, 246, 100, 134, 104, 152, 22, 212, 164, 92, 204, 93, 101, 182, 146, 108, 112, 72, 80, 253, 237, 185, 218, 94, 21, 70, 87, 167, 141, 157, 132, 144, 216, 171, 0, 140, 188, 211, 10, 247, 228, 88, 5, 184, 179, 69, 6, 208, 44, 30, 143, 202, 63, 15, 2, 193, 175, 189, 3, 1, 19, 138, 107, 58, 145, 17, 65, 79, 103, 220, 234, 151, 242, 207, 206, 240, 180, 230, 115, 150, 172, 116, 34, 231, 173, 53, 133, 226, 249, 55, 232, 28, 117, 223, 110, 71, 241, 26, 113, 29, 41, 197, 137, 111, 183, 98, 14, 170, 24, 190, 27, 252, 86, 62, 75, 198, 210, 121, 32, 154, 219, 192, 254, 120, 205, 90, 244, 31, 221, 168, 51, 136, 7, 199, 49, 177, 18, 16, 89, 39, 128, 236, 95, 96, 81, 127, 169, 25, 181, 74, 13, 45, 229, 122, 159, 147, 201, 156, 239, 160, 224, 59, 77, 174, 42, 245, 176, 200, 235, 187, 60, 131, 83, 153, 97, 23, 43, 4, 126, 186, 119, 214, 38, 225, 105, 20, 99, 85, 33, 12, 125};

    public Decryption(byte[] byArray) {
        this.key = byArray;
    }

    public byte[] encrypt(byte[] byArray) {
        byte[][] byArray2 = new byte[4][4];
        Decryption decryption = this;
        byte[][] byArray3 = decryption.expandKey(decryption.key);
        this.loadState(byArray, byArray2);
        this.addRoundKey(byArray2, byArray3[0]);
        for (int i = 1; i < 10; ++i) {
            this.substituteByte(byArray2, false);
            this.shiftRows(byArray2, false);
            Decryption.mixColumns(byArray2);
            this.addRoundKey(byArray2, byArray3[i]);
        }
        this.substituteByte(byArray2, false);
        this.shiftRows(byArray2, false);
        this.addRoundKey(byArray2, byArray3[10]);
        return this.extractMessage(byArray2);
    }

    public byte[] decrypt(byte[] byArray) {
        byte[][] byArray2 = new byte[4][4];
        Decryption decryption = this;
        byte[][] byArray3 = decryption.expandKey(decryption.key);
        this.loadState(byArray, byArray2);
        this.addRoundKey(byArray2, byArray3[10]);
        this.shiftRows(byArray2, true);
        this.substituteByte(byArray2, true);
        for (int i = 9; i > 0; --i) {
            this.addRoundKey(byArray2, byArray3[i]);
            Decryption.inverseMixColumns(byArray2);
            this.shiftRows(byArray2, true);
            this.substituteByte(byArray2, true);
        }
        this.addRoundKey(byArray2, byArray3[0]);
        return this.extractMessage(byArray2);
    }

    private byte[] keyScheduleCore(byte[] byArray, int n) {
        int n2 = byArray[0];
        byArray[0] = byArray[1];
        byArray[1] = byArray[2];
        byArray[2] = byArray[3];
        byArray[3] = n2;
        for (n2 = 0; n2 < 4; ++n2) {
            byArray[n2] = (byte)S_BOX[byArray[n2] & 0xFF];
        }
        byArray[0] = (byte)(byArray[0] ^ (byte)RCON[n]);
        return byArray;
    }

    private byte[][] expandKey(byte[] byArray) {
        int n;
        byte[][] byArray2 = new byte[11][16];
        byte[][] byArray3 = new byte[44][4];
        for (n = 0; n < 4; ++n) {
            System.arraycopy(byArray, n * 4, byArray3[n], 0, 4);
        }
        for (n = 4; n < byArray3.length; ++n) {
            byArray = (byte[])byArray3[n - 1].clone();
            if (n % 4 == 0) {
                byArray = this.keyScheduleCore(byArray, n / 4);
            }
            for (int i = 0; i < 4; ++i) {
                byArray3[n][i] = (byte)(byArray3[n - 4][i] ^ byArray[i]);
            }
        }
        for (n = 0; n <= 10; ++n) {
            for (int i = 0; i < 4; ++i) {
                System.arraycopy(byArray3[n * 4 + i], 0, byArray2[n], i * 4, 4);
            }
        }
        return byArray2;
    }

    private void loadState(byte[] byArray, byte[][] byArray2) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                byArray2[j][i] = byArray[n++];
            }
        }
    }

    private void addRoundKey(byte[][] byArray, byte[] byArray2) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                byte[] byArray3 = byArray[j];
                int n2 = i;
                byArray3[n2] = (byte)(byArray3[n2] ^ byArray2[n++]);
            }
        }
    }

    private void substituteByte(byte[][] byArray, boolean bl) {
        int[] nArray = bl ? I_S_BOX : S_BOX;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                byArray[j][i] = (byte)nArray[byArray[j][i] & 0xFF];
            }
        }
    }

    private void shiftRows(byte[][] byArray, boolean bl) {
        byte[] byArray2 = new byte[4];
        int n = bl ? -1 : 1;
        for (int i = 1; i < 4; ++i) {
            int n2;
            for (n2 = 0; n2 < 4; ++n2) {
                byArray2[n2] = byArray[i][n2];
            }
            for (n2 = 0; n2 < 4; ++n2) {
                byArray[i][n2] = byArray2[(n2 + i * n + 4) % 4];
            }
        }
    }

    private static void inverseMixColumns(byte[][] byArray) {
        byte[] byArray2 = new byte[4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                byArray2[j] = byArray[j][i];
            }
            byArray[0][i] = (byte)(Decryption.galoisMultiply(byArray2[0], 14) ^ Decryption.galoisMultiply(byArray2[3], 9) ^ Decryption.galoisMultiply(byArray2[2], 13) ^ Decryption.galoisMultiply(byArray2[1], 11));
            byArray[1][i] = (byte)(Decryption.galoisMultiply(byArray2[1], 14) ^ Decryption.galoisMultiply(byArray2[0], 9) ^ Decryption.galoisMultiply(byArray2[3], 13) ^ Decryption.galoisMultiply(byArray2[2], 11));
            byArray[2][i] = (byte)(Decryption.galoisMultiply(byArray2[2], 14) ^ Decryption.galoisMultiply(byArray2[1], 9) ^ Decryption.galoisMultiply(byArray2[0], 13) ^ Decryption.galoisMultiply(byArray2[3], 11));
            byArray[3][i] = (byte)(Decryption.galoisMultiply(byArray2[3], 14) ^ Decryption.galoisMultiply(byArray2[2], 9) ^ Decryption.galoisMultiply(byArray2[1], 13) ^ Decryption.galoisMultiply(byArray2[0], 11));
        }
    }

    private static void mixColumns(byte[][] byArray) {
        int n;
        int n2;
        byte[][] byArrayArray = new byte[][]{{2, 3, 1, 1}, {1, 2, 3, 1}, {1, 1, 2, 3}, {3, 1, 1, 2}};
        byte[][] byArray2 = new byte[4][4];
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                int n3 = 0;
                for (int i = 0; i < 4; ++i) {
                    byte by = byArrayArray[n2][i];
                    byte by2 = byArray[i][n];
                    n3 ^= Decryption.galoisMultiply(by, by2);
                }
                byArray2[n2][n] = (byte)n3;
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                byArray[n2][n] = byArray2[n2][n];
            }
        }
    }

    private static byte galoisMultiply(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < 8; ++i) {
            if ((n2 & 1) == 1) {
                n3 ^= n;
            }
            int n4 = n & 0x80;
            n <<= 1;
            if (n4 == 128) {
                n ^= 0x1B;
            }
            n2 >>= 1;
        }
        return (byte)(n3 &= 0xFF);
    }

    private byte[] extractMessage(byte[][] byArray) {
        int n = 0;
        byte[] byArray2 = new byte[16];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                byArray2[n++] = byArray[j][i];
            }
        }
        return byArray2;
    }
}

