/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import java.util.Locale;
import java.util.Scanner;

public class SecureSystem {
    private static final int[] successfulLogins = new int[UserDataStorage.TRACKER.length];
    private static final int[] unsuccessfulLogins = new int[UserDataStorage.TRACKER.length];

    private static int computeUsernameId(String username) {
        int hash = 0;
        for (int i = 0; i < username.length(); ++i) {
            hash += username.charAt(i) * (i + 7) - i * 13;
        }
        if ((hash = (hash * 17 + 31) % 100) < 0) {
            hash += 100;
        }
        return hash;
    }

    private static int computePasswordId(String username) {
        int hash = 0;
        for (int i = 0; i < username.length(); ++i) {
            hash += username.charAt(i) * (i + 11) + i * 18;
        }
        if ((hash = (hash * 24 - 44) % 100) < 0) {
            hash += 100;
        }
        return hash;
    }

    private static int computeSecretMessageId(String username) {
        int hash = 0;
        for (int i = 0; i < username.length(); ++i) {
            hash += username.charAt(i) * (i + 5) ^ i * 29;
        }
        if ((hash = (hash * 37 + 73) % 100) < 0) {
            hash += 100;
        }
        return hash;
    }

    private static void printUserList() {
        System.out.println();
        System.out.printf("%-16s %-20s %-20s%n", "User", "Successful Logins", "Unsuccessful Logins");
        System.out.println("--------------------------------------------------------------");
        for (int i = 0; i < UserDataStorage.TRACKER.length; ++i) {
            System.out.printf("%-16s %-20d %-20d%n", UserDataStorage.TRACKER[i], successfulLogins[i], unsuccessfulLogins[i]);
        }
        System.out.println();
    }

    private static void handleLogin(Scanner scanner, UsernameEncryptor uEncrypt, PasswordEncryptor pEncrypt, SecretDecryptor sDecrypt) {
        System.out.print("Enter username: ");
        String rawUsername = scanner.nextLine().trim();
        System.out.print("Enter password: ");
        String rawPassword = scanner.nextLine().trim();
        String encryptedUsername = uEncrypt.encrypt(rawUsername, rawPassword);
        String encryptedPassword = PasswordEncryptor.encrypt(rawUsername, rawPassword);
        int usernameId = SecureSystem.computeUsernameId(rawUsername);
        int passwordId = SecureSystem.computePasswordId(rawUsername);
        int secretId = SecureSystem.computeSecretMessageId(rawUsername);
        int trackerId = Arrays.asList(UserDataStorage.TRACKER).indexOf(rawUsername);
        if (trackerId != -1) {
            String secret = SecretDecryptor.decrypt(encryptedUsername, encryptedPassword, UserDataStorage.SECRET_MESSAGES[secretId]);
            if (secret.matches("[a-zA-Z .,;:!?()'\"-]*")) {
                int n = trackerId;
                successfulLogins[n] = successfulLogins[n] + 1;
                System.out.println("Login successful. Secret message:");
                System.out.println(">>> " + secret);
            } else {
                int n = trackerId;
                unsuccessfulLogins[n] = unsuccessfulLogins[n] + 1;
                System.out.println("Login failed: decrypted secret contains invalid characters.");
            }
        } else {
            System.out.println("Login failed: username does not exist.");
        }
    }

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in).useLocale(Locale.US);
        UsernameEncryptor uEncrypt = new UsernameEncryptor();
        PasswordEncryptor pEncrypt = new PasswordEncryptor();
        SecretDecryptor sDecrypt = new SecretDecryptor();
        System.out.println("Welcome to the Security System.");
        System.out.println("This program will run until you choose Quit from the menu.");
        boolean running = true;
        block18: while (running) {
            try {
                String choice;
                System.out.println();
                System.out.println("Menu:");
                System.out.println("  1) Login");
                System.out.println("  2) List Users");
                System.out.println("  3) Quit");
                System.out.print("Choose an option (1-3): ");
                switch (choice = scanner.nextLine().trim()) {
                    case "1": 
                    case "Login": 
                    case "login": {
                        SecureSystem.handleLogin(scanner, uEncrypt, pEncrypt, sDecrypt);
                        continue block18;
                    }
                    case "2": 
                    case "List": 
                    case "list": {
                        SecureSystem.printUserList();
                        continue block18;
                    }
                    case "3": 
                    case "Quit": 
                    case "quit": {
                        System.out.println("Quitting program.");
                        running = false;
                        continue block18;
                    }
                }
                System.out.println("Invalid menu option. Please enter 1, 2, or 3.");
            }
            catch (Exception e) {
                System.out.println("An unexpected error occurred: " + e.getMessage());
                System.out.println("The system will continue to run. Choose 'Quit' to exit safely.");
            }
        }
        scanner.close();
    }
}

