/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;

public final class SHA256 {
    private static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};

    static byte[] hash(byte[] message) {
        int h0 = 1779033703;
        int h1 = -1150833019;
        int h2 = 1013904242;
        int h3 = -1521486534;
        int h4 = 1359893119;
        int h5 = -1694144372;
        int h6 = 528734635;
        int h7 = 1541459225;
        int len = message.length;
        long bitLen = (long)len * 8L;
        int padLen = 64 - (len + 9) % 64;
        int totalLen = len + 1 + padLen + 8;
        byte[] padded = new byte[totalLen];
        System.arraycopy(message, 0, padded, 0, len);
        padded[len] = -128;
        for (int i = 0; i < 8; ++i) {
            padded[totalLen - 1 - i] = (byte)(bitLen >>> 8 * i & 0xFFL);
        }
        int[] w = new int[64];
        for (int chunkOffset = 0; chunkOffset < totalLen; chunkOffset += 64) {
            for (int i = 0; i < 16; ++i) {
                int j = chunkOffset + i * 4;
                w[i] = (padded[j] & 0xFF) << 24 | (padded[j + 1] & 0xFF) << 16 | (padded[j + 2] & 0xFF) << 8 | padded[j + 3] & 0xFF;
            }
            for (int t = 16; t < 64; ++t) {
                int s0 = Integer.rotateRight(w[t - 15], 7) ^ Integer.rotateRight(w[t - 15], 18) ^ w[t - 15] >>> 3;
                int s1 = Integer.rotateRight(w[t - 2], 17) ^ Integer.rotateRight(w[t - 2], 19) ^ w[t - 2] >>> 10;
                w[t] = SHA256.safeAdd(SHA256.safeAdd(SHA256.safeAdd(w[t - 16], s0), w[t - 7]), s1);
            }
            int a = h0;
            int b = h1;
            int c = h2;
            int d = h3;
            int e = h4;
            int f = h5;
            int g = h6;
            int h = h7;
            for (int t = 0; t < 64; ++t) {
                int S1 = Integer.rotateRight(e, 6) ^ Integer.rotateRight(e, 11) ^ Integer.rotateRight(e, 25);
                int ch = e & f ^ ~e & g;
                int temp1 = SHA256.safeAdd(SHA256.safeAdd(SHA256.safeAdd(SHA256.safeAdd(h, S1), ch), K[t]), w[t]);
                int S0 = Integer.rotateRight(a, 2) ^ Integer.rotateRight(a, 13) ^ Integer.rotateRight(a, 22);
                int maj = a & b ^ a & c ^ b & c;
                int temp2 = SHA256.safeAdd(S0, maj);
                h = g;
                g = f;
                f = e;
                e = SHA256.safeAdd(d, temp1);
                d = c;
                c = b;
                b = a;
                a = SHA256.safeAdd(temp1, temp2);
            }
            h0 = SHA256.safeAdd(h0, a);
            h1 = SHA256.safeAdd(h1, b);
            h2 = SHA256.safeAdd(h2, c);
            h3 = SHA256.safeAdd(h3, d);
            h4 = SHA256.safeAdd(h4, e);
            h5 = SHA256.safeAdd(h5, f);
            h6 = SHA256.safeAdd(h6, g);
            h7 = SHA256.safeAdd(h7, h);
            Arrays.fill(w, 0);
        }
        byte[] out = new byte[32];
        SHA256.intToBytes(h0, out, 0);
        SHA256.intToBytes(h1, out, 4);
        SHA256.intToBytes(h2, out, 8);
        SHA256.intToBytes(h3, out, 12);
        SHA256.intToBytes(h4, out, 16);
        SHA256.intToBytes(h5, out, 20);
        SHA256.intToBytes(h6, out, 24);
        SHA256.intToBytes(h7, out, 28);
        return out;
    }

    private static void intToBytes(int val, byte[] buf, int off) {
        buf[off] = (byte)(val >>> 24 & 0xFF);
        buf[off + 1] = (byte)(val >>> 16 & 0xFF);
        buf[off + 2] = (byte)(val >>> 8 & 0xFF);
        buf[off + 3] = (byte)(val & 0xFF);
    }

    private static int safeAdd(int a, int b) {
        return a + b;
    }
}

