/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;

public final class KeyFromCredentials {
    private KeyFromCredentials() {
    }

    public static byte[] deriveKey128(String username, String password) {
        if (username == null) {
            throw new IllegalArgumentException("username is null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password is null");
        }
        byte[] userBytes = username.getBytes();
        byte[] passBytes = password.getBytes();
        try {
            byte[] combined = new byte[userBytes.length + 1 + passBytes.length];
            System.arraycopy(userBytes, 0, combined, 0, userBytes.length);
            combined[userBytes.length] = 58;
            System.arraycopy(passBytes, 0, combined, userBytes.length + 1, passBytes.length);
            byte[] hash = SHA256.hash(combined);
            byte[] key128 = Arrays.copyOf(hash, 16);
            Arrays.fill(combined, (byte)0);
            Arrays.fill(hash, (byte)0);
            Arrays.fill(passBytes, (byte)0);
            return key128;
        }
        catch (Exception e) {
            System.out.println("Failed to create key. Please use a different username or password.");
            return null;
        }
    }
}

