/*
 * Decompiled with CFR 0.152.
 */
public class AES {
    private static final int columns = 4;
    private static final int keyLength = 4;
    private static final int rounds = 10;
    private int[][] roundKeyWords;
    private static final int[] ROUNDCONST = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 27, 54};
    private static final int[] sbox = new int[]{99, 124, 119, 123, 242, 107, 111, 197, 48, 1, 103, 43, 254, 215, 171, 118, 202, 130, 201, 125, 250, 89, 71, 240, 173, 212, 162, 175, 156, 164, 114, 192, 183, 253, 147, 38, 54, 63, 247, 204, 52, 165, 229, 241, 113, 216, 49, 21, 4, 199, 35, 195, 24, 150, 5, 154, 7, 18, 128, 226, 235, 39, 178, 117, 9, 131, 44, 26, 27, 110, 90, 160, 82, 59, 214, 179, 41, 227, 47, 132, 83, 209, 0, 237, 32, 252, 177, 91, 106, 203, 190, 57, 74, 76, 88, 207, 208, 239, 170, 251, 67, 77, 51, 133, 69, 249, 2, 127, 80, 60, 159, 168, 81, 163, 64, 143, 146, 157, 56, 245, 188, 182, 218, 33, 16, 255, 243, 210, 205, 12, 19, 236, 95, 151, 68, 23, 196, 167, 126, 61, 100, 93, 25, 115, 96, 129, 79, 220, 34, 42, 144, 136, 70, 238, 184, 20, 222, 94, 11, 219, 224, 50, 58, 10, 73, 6, 36, 92, 194, 211, 172, 98, 145, 149, 228, 121, 231, 200, 55, 109, 141, 213, 78, 169, 108, 86, 244, 234, 101, 122, 174, 8, 186, 120, 37, 46, 28, 166, 180, 198, 232, 221, 116, 31, 75, 189, 139, 138, 112, 62, 181, 102, 72, 3, 246, 14, 97, 53, 87, 185, 134, 193, 29, 158, 225, 248, 152, 17, 105, 217, 142, 148, 155, 30, 135, 233, 206, 85, 40, 223, 140, 161, 137, 13, 191, 230, 66, 104, 65, 153, 45, 15, 176, 84, 187, 22};
    private static final int[] invSbox = new int[]{82, 9, 106, 213, 48, 54, 165, 56, 191, 64, 163, 158, 129, 243, 215, 251, 124, 227, 57, 130, 155, 47, 255, 135, 52, 142, 67, 68, 196, 222, 233, 203, 84, 123, 148, 50, 166, 194, 35, 61, 238, 76, 149, 11, 66, 250, 195, 78, 8, 46, 161, 102, 40, 217, 36, 178, 118, 91, 162, 73, 109, 139, 209, 37, 114, 248, 246, 100, 134, 104, 152, 22, 212, 164, 92, 204, 93, 101, 182, 146, 108, 112, 72, 80, 253, 237, 185, 218, 94, 21, 70, 87, 167, 141, 157, 132, 144, 216, 171, 0, 140, 188, 211, 10, 247, 228, 88, 5, 184, 179, 69, 6, 208, 44, 30, 143, 202, 63, 15, 2, 193, 175, 189, 3, 1, 19, 138, 107, 58, 145, 17, 65, 79, 103, 220, 234, 151, 242, 207, 206, 240, 180, 230, 115, 150, 172, 116, 34, 231, 173, 53, 133, 226, 249, 55, 232, 28, 117, 223, 110, 71, 241, 26, 113, 29, 41, 197, 137, 111, 183, 98, 14, 170, 24, 190, 27, 252, 86, 62, 75, 198, 210, 121, 32, 154, 219, 192, 254, 120, 205, 90, 244, 31, 221, 168, 51, 136, 7, 199, 49, 177, 18, 16, 89, 39, 128, 236, 95, 96, 81, 127, 169, 25, 181, 74, 13, 45, 229, 122, 159, 147, 201, 156, 239, 160, 224, 59, 77, 174, 42, 245, 176, 200, 235, 187, 60, 131, 83, 153, 97, 23, 43, 4, 126, 186, 119, 214, 38, 225, 105, 20, 99, 85, 33, 12, 125};

    public AES(byte[] key) {
        if (key == null || key.length != 16) {
            throw new IllegalArgumentException("Key must be 16 bytes");
        }
        this.keyExpansion(key);
    }

    private void keyExpansion(byte[] key) {
        int words = 44;
        this.roundKeyWords = new int[words][4];
        for (int i = 0; i < 4; ++i) {
            this.roundKeyWords[i][0] = key[4 * i] & 0xFF;
            this.roundKeyWords[i][1] = key[4 * i + 1] & 0xFF;
            this.roundKeyWords[i][2] = key[4 * i + 2] & 0xFF;
            this.roundKeyWords[i][3] = key[4 * i + 3] & 0xFF;
        }
        int[] temp = new int[4];
        for (int i = 4; i < words; ++i) {
            System.arraycopy(this.roundKeyWords[i - 1], 0, temp, 0, 4);
            if (i % 4 == 0) {
                int t = temp[0];
                temp[0] = temp[1];
                temp[1] = temp[2];
                temp[2] = temp[3];
                temp[3] = t;
                temp[0] = sbox[temp[0] & 0xFF];
                temp[1] = sbox[temp[1] & 0xFF];
                temp[2] = sbox[temp[2] & 0xFF];
                temp[3] = sbox[temp[3] & 0xFF];
                temp[0] = temp[0] ^ ROUNDCONST[i / 4 - 1];
            }
            this.roundKeyWords[i][0] = this.roundKeyWords[i - 4][0] ^ temp[0];
            this.roundKeyWords[i][1] = this.roundKeyWords[i - 4][1] ^ temp[1];
            this.roundKeyWords[i][2] = this.roundKeyWords[i - 4][2] ^ temp[2];
            this.roundKeyWords[i][3] = this.roundKeyWords[i - 4][3] ^ temp[3];
        }
    }

    public byte[] encryptBlock(byte[] input) {
        if (input.length != 16) {
            throw new IllegalArgumentException("Block must be 16 bytes");
        }
        int[][] state = new int[4][4];
        for (int i = 0; i < 16; ++i) {
            state[i % 4][i / 4] = input[i] & 0xFF;
        }
        this.addRoundKey(state, 0);
        for (int round = 1; round <= 9; ++round) {
            this.subBytes(state);
            this.shiftRows(state);
            this.mixColumns(state);
            this.addRoundKey(state, round);
        }
        this.subBytes(state);
        this.shiftRows(state);
        this.addRoundKey(state, 10);
        byte[] output = new byte[16];
        for (int i = 0; i < 16; ++i) {
            output[i] = (byte)(state[i % 4][i / 4] & 0xFF);
        }
        return output;
    }

    public byte[] decryptBlock(byte[] input) {
        if (input.length != 16) {
            throw new IllegalArgumentException("Block must be 16 bytes");
        }
        int[][] state = new int[4][4];
        for (int i = 0; i < 16; ++i) {
            state[i % 4][i / 4] = input[i] & 0xFF;
        }
        this.addRoundKey(state, 10);
        for (int round = 9; round >= 1; --round) {
            this.invShiftRows(state);
            this.invSubBytes(state);
            this.addRoundKey(state, round);
            this.inverseMixColumns(state);
        }
        this.invShiftRows(state);
        this.invSubBytes(state);
        this.addRoundKey(state, 0);
        byte[] output = new byte[16];
        for (int i = 0; i < 16; ++i) {
            output[i] = (byte)(state[i % 4][i / 4] & 0xFF);
        }
        return output;
    }

    private void addRoundKey(int[][] state, int round) {
        int startWord = round * 4;
        for (int c = 0; c < 4; ++c) {
            int[] word = this.roundKeyWords[startWord + c];
            for (int r = 0; r < 4; ++r) {
                int[] nArray = state[r];
                int n = c;
                nArray[n] = nArray[n] ^ word[r];
            }
        }
    }

    private void subBytes(int[][] state) {
        for (int r = 0; r < 4; ++r) {
            for (int c = 0; c < 4; ++c) {
                state[r][c] = sbox[state[r][c] & 0xFF];
            }
        }
    }

    private void invSubBytes(int[][] state) {
        for (int r = 0; r < 4; ++r) {
            for (int c = 0; c < 4; ++c) {
                state[r][c] = invSbox[state[r][c] & 0xFF];
            }
        }
    }

    private void shiftRows(int[][] state) {
        int temp = state[1][0];
        state[1][0] = state[1][1];
        state[1][1] = state[1][2];
        state[1][2] = state[1][3];
        state[1][3] = temp;
        int temp0 = state[2][0];
        int temp1 = state[2][1];
        state[2][0] = state[2][2];
        state[2][1] = state[2][3];
        state[2][2] = temp0;
        state[2][3] = temp1;
        temp = state[3][3];
        state[3][3] = state[3][2];
        state[3][2] = state[3][1];
        state[3][1] = state[3][0];
        state[3][0] = temp;
    }

    private void invShiftRows(int[][] state) {
        int tmp = state[1][3];
        state[1][3] = state[1][2];
        state[1][2] = state[1][1];
        state[1][1] = state[1][0];
        state[1][0] = tmp;
        int tmp0 = state[2][0];
        int tmp1 = state[2][1];
        state[2][0] = state[2][2];
        state[2][1] = state[2][3];
        state[2][2] = tmp0;
        state[2][3] = tmp1;
        tmp = state[3][0];
        state[3][0] = state[3][1];
        state[3][1] = state[3][2];
        state[3][2] = state[3][3];
        state[3][3] = tmp;
    }

    private void mixColumns(int[][] state) {
        for (int c = 0; c < 4; ++c) {
            int a0 = state[0][c];
            int a1 = state[1][c];
            int a2 = state[2][c];
            int a3 = state[3][c];
            int r0 = AES.galoisMultiply(a0, 2) ^ AES.galoisMultiply(a1, 3) ^ AES.galoisMultiply(a2, 1) ^ AES.galoisMultiply(a3, 1);
            int r1 = AES.galoisMultiply(a0, 1) ^ AES.galoisMultiply(a1, 2) ^ AES.galoisMultiply(a2, 3) ^ AES.galoisMultiply(a3, 1);
            int r2 = AES.galoisMultiply(a0, 1) ^ AES.galoisMultiply(a1, 1) ^ AES.galoisMultiply(a2, 2) ^ AES.galoisMultiply(a3, 3);
            int r3 = AES.galoisMultiply(a0, 3) ^ AES.galoisMultiply(a1, 1) ^ AES.galoisMultiply(a2, 1) ^ AES.galoisMultiply(a3, 2);
            state[0][c] = r0 & 0xFF;
            state[1][c] = r1 & 0xFF;
            state[2][c] = r2 & 0xFF;
            state[3][c] = r3 & 0xFF;
        }
    }

    private void inverseMixColumns(int[][] state) {
        byte[] a = new byte[4];
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 4; ++i) {
                a[i] = (byte)state[i][j];
            }
            state[0][j] = (AES.galoisMultiply(a[0] & 0xFF, 14) ^ AES.galoisMultiply(a[3] & 0xFF, 9) ^ AES.galoisMultiply(a[2] & 0xFF, 13) ^ AES.galoisMultiply(a[1] & 0xFF, 11)) & 0xFF;
            state[1][j] = (AES.galoisMultiply(a[1] & 0xFF, 14) ^ AES.galoisMultiply(a[0] & 0xFF, 9) ^ AES.galoisMultiply(a[3] & 0xFF, 13) ^ AES.galoisMultiply(a[2] & 0xFF, 11)) & 0xFF;
            state[2][j] = (AES.galoisMultiply(a[2] & 0xFF, 14) ^ AES.galoisMultiply(a[1] & 0xFF, 9) ^ AES.galoisMultiply(a[0] & 0xFF, 13) ^ AES.galoisMultiply(a[3] & 0xFF, 11)) & 0xFF;
            state[3][j] = (AES.galoisMultiply(a[3] & 0xFF, 14) ^ AES.galoisMultiply(a[2] & 0xFF, 9) ^ AES.galoisMultiply(a[1] & 0xFF, 13) ^ AES.galoisMultiply(a[0] & 0xFF, 11)) & 0xFF;
        }
    }

    private static int galoisMultiply(int a, int b) {
        int p = 0;
        for (int i = 0; i < 8; ++i) {
            if ((b & 1) == 1) {
                p ^= a;
            }
            int hiBit = a & 0x80;
            a <<= 1;
            if (hiBit == 128) {
                a ^= 0x1B;
            }
            b >>= 1;
        }
        return p & 0xFF;
    }
}

