/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;

public class UserData
extends TreeMap<String, UserData> {
    TreeMap<String, User> logins = new TreeMap();

    UserData() {
        this.logins.put("alani1", new User("alani1", "7A69826535EF975B19EA65C211D257A5D5393DC3AC3A699F32392110ECA42E", "1F5A28B965031833074C935178ECDD87B76BDF53BB139A728ACC6A667605347C3B94CE9BEDFFAB6C42FAED9566F4726BCB71C189BF2997B1779D6158CDB7C146"));
        this.logins.put("garantche2", new User("garantche2", "2AE689C42267735E959DE91EEC28F71521E26AA41F65C231A627755CBB7FA233", "0FB71DF92F4D530D12C2701D3E94BFBBC919BC7674EC85C064755452E6302439614E0F7695A7EAB9F8F1E37CFB60077A"));
        this.logins.put("guest", new User("guest", "buttcheeksbuttcheeksbuttcheeks", "422E6483E0A52ABE06D3D40F7B036325E24649ACF6EA0D8C9CB2875C651BF4D5DB84138F4906F01F90C7DD0CE42823DEEE954E6EA3093DF8CBA0632958AA0082A392F7087AADF69AA30CC55972EB1511"));
        this.logins.put("kent4", new User("kent4", "6A8C2998A37BE7E8CEC7A7FC673BC4905CF7B5E53BCDBFB2D5D894E6CFCA874C", "901C18EAFFDB319AC58C08017B7D043923AE90C917C95246AF5CD34832AE68C6"));
        this.logins.put("hinkle5", new User("hinkle5", "BD82857F7A9A60A81CC6FB2D256E1BA9B2D16BBEF1CDD8A98A79E99A1ECD4794", "B1A64E6688C7B70E0FC1B1B5FA66466FE7CACE6EA563C4A1C0098FAD6FD1F8D8"));
        this.logins.put("perez10", new User("perez10", "FD5DB851F42B27C96E4F9F804E944868CF398C3C2382A3254E356983F7886", "23350BAEBD86682CDDFD78F312ABB386E74A4A7DBEA793AD2B9FC69E813C49EB363E7172AB1D93C52B989163D702A032C078768C4B615BF6F5D95B2F3D96E5E90240D3B329E7A53236C6FCFEE64960AC"));
        this.logins.put("rheyne1", new User("rheyne1", "A655B499BE4F7849B429936E85E711D5B7B2A9A0EF16A3352B33D3261FFE96", "4703EF4DE939145F5A3DBE7277C3A03F71933D8B2ED54C48485B7739BD517ADF32E4E046C26C4059FCB96AE7AC8A5BE2"));
        this.logins.put("toure3", new User("toure3", "401157B64A21B346935FCC8AA3DBF9E239DBABCC27AAEA36125C794CE897", "BCC74F62F9A257916F44AF557C9762B58B54CB9B4FC71282ADB4CA8C60432F5D4FDF3BA8E1A60A91F4957004842324B233D113F70348B86B9AA635DA7627BEE0CEDE01D5055772161F987CA2591B4C0F"));
        this.logins.put("wittman1", new User("wittman1", "F85124C97DDDF4B31E20DE95DD25402F95E34EF3E7E48C8F106B7F817AC19068", "4A7CF01921745C4EA68ED8E422519E2843799180B1C6535B0DB74035BA5A5C316D007CFE6DFA65ED6918A86E5AF8328FAC29BCD80E8C585133DFE808804A4ADCD800093D46C4268C4AB2754381B50A9B"));
    }

    public byte[] testPass(String name, String pass) {
        int i;
        byte[] text = pass.getBytes();
        text = this.addPadding(text, name);
        byte[] output = new byte[text.length];
        int outputIndex = 0;
        for (int textIndex = 0; textIndex < text.length; textIndex += 16) {
            int remaining = Math.min(16, text.length - textIndex);
            byte[] currState = Arrays.copyOfRange(text, textIndex, textIndex + remaining);
            byte[][] roundKeys = UserData.generateRoundKey(this.logins.get((Object)name).salt);
            for (i = 0; i < remaining; ++i) {
                int n = i;
                currState[n] = (byte)(currState[n] ^ roundKeys[0][i]);
            }
            for (int round = 1; round < 11; ++round) {
                int i2;
                currState = UserData.subWord(currState);
                byte[][] matrix = UserData.loadBlock(currState);
                for (i2 = 0; i2 < 4; ++i2) {
                    for (int j = 0; j < i2; ++j) {
                        matrix[i2] = UserData.rotWord(matrix[i2]);
                    }
                }
                if (round != 10) {
                    UserData.mixColumns(matrix);
                }
                currState = UserData.unloadBlock(matrix);
                for (i2 = 0; i2 < 16; ++i2) {
                    int n = i2;
                    currState[n] = (byte)(currState[n] ^ roundKeys[round][i2]);
                }
            }
            for (i = 0; i < 16; ++i) {
                output[outputIndex++] = currState[i];
            }
        }
        int index = this.logins.get((Object)name).salt.length - 1;
        byte[] newPass = new byte[output.length];
        int passIndex = 0;
        for (i = 0; i < output.length; ++i) {
            byte temp = this.logins.get((Object)name).salt[index];
            int n = passIndex++;
            int n2 = i;
            byte by = (byte)(output[n2] ^ temp);
            output[n2] = by;
            newPass[n] = by;
            if (--index != 0) continue;
            index = this.logins.get((Object)name).salt.length - 1;
        }
        newPass = this.mix(newPass);
        return newPass;
    }

    public static byte[][] generateRoundKey(byte[] key) {
        byte[][] newKey = new byte[11][16];
        System.arraycopy(key, 0, newKey[0], 0, 16);
        for (int roundKeyIndex = 1; roundKeyIndex < 11; ++roundKeyIndex) {
            int wordByteIndex;
            int prev = roundKeyIndex - 1;
            byte[] word3 = new byte[4];
            System.arraycopy(newKey[prev], 12, word3, 0, 4);
            word3 = UserData.rotWord(word3);
            word3 = UserData.subWord(word3);
            word3 = UserData.rCon(word3, roundKeyIndex);
            for (wordByteIndex = 0; wordByteIndex < 4; ++wordByteIndex) {
                newKey[roundKeyIndex][wordByteIndex] = (byte)(newKey[prev][wordByteIndex] ^ word3[wordByteIndex]);
            }
            for (wordByteIndex = 4; wordByteIndex < 16; ++wordByteIndex) {
                newKey[roundKeyIndex][wordByteIndex] = (byte)(newKey[roundKeyIndex][wordByteIndex - 4] ^ newKey[prev][wordByteIndex]);
            }
        }
        return newKey;
    }

    public byte[] addPadding(byte[] text, String name) {
        int padLen = 16 - text.length % 16;
        byte[] padded = Arrays.copyOf(text, text.length + padLen);
        byte[] salt = this.logins.get((Object)name).salt;
        for (int i = text.length; i < padded.length; ++i) {
            padded[i] = salt[(i - text.length) % salt.length];
        }
        return padded;
    }

    private static byte[] rotWord(byte[] word) {
        byte[] newWord = new byte[4];
        byte temp = word[0];
        for (int i = 0; i < 4; ++i) {
            newWord[i] = i != 3 ? word[i + 1] : temp;
        }
        return newWord;
    }

    private static byte getSboxIndex(int index) {
        int[] sBox = new int[]{99, 124, 119, 123, 242, 107, 111, 197, 48, 1, 103, 43, 254, 215, 171, 118, 202, 130, 201, 125, 250, 89, 71, 240, 173, 212, 162, 175, 156, 164, 114, 192, 183, 253, 147, 38, 54, 63, 247, 204, 52, 165, 229, 241, 113, 216, 49, 21, 4, 199, 35, 195, 24, 150, 5, 154, 7, 18, 128, 226, 235, 39, 178, 117, 9, 131, 44, 26, 27, 110, 90, 160, 82, 59, 214, 179, 41, 227, 47, 132, 83, 209, 0, 237, 32, 252, 177, 91, 106, 203, 190, 57, 74, 76, 88, 207, 208, 239, 170, 251, 67, 77, 51, 133, 69, 249, 2, 127, 80, 60, 159, 168, 81, 163, 64, 143, 146, 157, 56, 245, 188, 182, 218, 33, 16, 255, 243, 210, 205, 12, 19, 236, 95, 151, 68, 23, 196, 167, 126, 61, 100, 93, 25, 115, 96, 129, 79, 220, 34, 42, 144, 136, 70, 238, 184, 20, 222, 94, 11, 219, 224, 50, 58, 10, 73, 6, 36, 92, 194, 211, 172, 98, 145, 149, 228, 121, 231, 200, 55, 109, 141, 213, 78, 169, 108, 86, 244, 234, 101, 122, 174, 8, 186, 120, 37, 46, 28, 166, 180, 198, 232, 221, 116, 31, 75, 189, 139, 138, 112, 62, 181, 102, 72, 3, 246, 14, 97, 53, 87, 185, 134, 193, 29, 158, 225, 248, 152, 17, 105, 217, 142, 148, 155, 30, 135, 233, 206, 85, 40, 223, 140, 161, 137, 13, 191, 230, 66, 104, 65, 153, 45, 15, 176, 84, 187, 22};
        return (byte)sBox[index];
    }

    private static byte[] subWord(byte[] word) {
        byte[] newWord = new byte[word.length];
        for (int i = 0; i < word.length; ++i) {
            byte substitute;
            int index = word[i] & 0xFF;
            newWord[i] = substitute = UserData.getSboxIndex(index);
        }
        return newWord;
    }

    private static byte[] rCon(byte[] word, int roundNum) {
        byte[] newWord = word;
        int[] roundConstant = new int[]{141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203, 141, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145, 57, 114, 228, 211, 189, 97, 194, 159, 37, 74, 148, 51, 102, 204, 131, 29, 58, 116, 232, 203};
        newWord[0] = (byte)(word[0] ^ roundConstant[roundNum]);
        return newWord;
    }

    private static void mixColumns(byte[][] state) {
        for (int c = 0; c < 4; ++c) {
            byte a0 = state[0][c];
            byte a1 = state[1][c];
            byte a2 = state[2][c];
            byte a3 = state[3][c];
            state[0][c] = (byte)(UserData.multiply((byte)2, a0) ^ UserData.multiply((byte)3, a1) ^ a2 ^ a3);
            state[1][c] = (byte)(a0 ^ UserData.multiply((byte)2, a1) ^ UserData.multiply((byte)3, a2) ^ a3);
            state[2][c] = (byte)(a0 ^ a1 ^ UserData.multiply((byte)2, a2) ^ UserData.multiply((byte)3, a3));
            state[3][c] = (byte)(UserData.multiply((byte)3, a0) ^ a1 ^ a2 ^ UserData.multiply((byte)2, a3));
        }
    }

    private static byte multiply(byte a, byte b) {
        int result = 0;
        int x = a & 0xFF;
        int y = b & 0xFF;
        for (int i = 0; i < 8; ++i) {
            if ((y & 1) != 0) {
                result ^= x;
            }
            boolean carry = (x & 0x80) != 0;
            x = x << 1 & 0xFF;
            if (carry) {
                x ^= 0x1B;
            }
            y >>= 1;
        }
        return (byte)(result & 0xFF);
    }

    public static byte[][] loadBlock(byte[] data) {
        byte[][] block = new byte[4][4];
        int index = 0;
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 4; ++i) {
                block[i][j] = data[index++];
            }
        }
        return block;
    }

    private static byte[] unloadBlock(byte[][] matrix) {
        byte[] temp = new byte[16];
        int index = 0;
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 4; ++i) {
                temp[index++] = matrix[i][j];
            }
        }
        return temp;
    }

    private byte[] mix(byte[] finalHash) {
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        for (int i = 0; i < finalHash.length; i += 16) {
            int to = Math.min(i + 16, finalHash.length);
            chunks.add(Arrays.copyOfRange(finalHash, i, to));
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        for (byte[] b : chunks) {
            output.write(b, 0, b.length);
        }
        return output.toByteArray();
    }

    public static class User {
        final String username;
        final byte[] salt;
        private int successful = 0;
        private int unsuccessful = 0;
        private final String messages;

        User(String username, String salt, String messages) {
            this.username = username;
            this.salt = salt.getBytes();
            this.messages = messages;
        }

        private static byte[] hexToBytes(String hex) {
            if (((String)hex).length() % 2 != 0) {
                hex = "0" + (String)hex;
            }
            int len = ((String)hex).length();
            byte[] data = new byte[len / 2];
            for (int i = 0; i < len; i += 2) {
                data[i / 2] = (byte)((Character.digit(((String)hex).charAt(i), 16) << 4) + Character.digit(((String)hex).charAt(i + 1), 16));
            }
            return data;
        }

        public boolean checkMessage(byte[] bytes) {
            return Arrays.equals(bytes, User.hexToBytes(this.messages));
        }

        public byte[] getCipherMessage() {
            return User.hexToBytes(this.messages);
        }

        public int getUnsuccessful() {
            return this.unsuccessful;
        }

        public void setUnsuccessful(int unsuccessful) {
            this.unsuccessful = unsuccessful;
        }

        public int getSuccessful() {
            return this.successful;
        }

        public void setSuccessful(int successful) {
            this.successful = successful;
        }
    }
}

