/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;

public class AES {
    public static byte[] encrypt(byte[] hashed, byte[] message) {
        byte[] padded = AES.addPadding(message);
        byte[][] roundKeys = UserData.generateRoundKey(hashed);
        byte[] cipherText = new byte[padded.length];
        for (int start = 0; start < padded.length; start += 16) {
            byte[] state = Arrays.copyOfRange(padded, start, start + 16);
            for (int i = 0; i < 16; ++i) {
                int n = i;
                state[n] = (byte)(state[n] ^ roundKeys[0][i]);
            }
            for (int round = 1; round < 11; ++round) {
                state = AES.subBytes(state);
                byte[][] matrix = AES.loadBlock(state);
                AES.shiftRows(matrix);
                if (round != 10) {
                    AES.mixColumns(matrix);
                }
                state = AES.unloadBlock(matrix);
                for (int i = 0; i < 16; ++i) {
                    int n = i;
                    state[n] = (byte)(state[n] ^ roundKeys[round][i]);
                }
            }
            System.arraycopy(state, 0, cipherText, start, 16);
        }
        return cipherText;
    }

    public static byte[] decrypt(byte[] hashed, byte[] cipherText) {
        byte[][] roundKeys = UserData.generateRoundKey(hashed);
        byte[] plainText = new byte[cipherText.length];
        for (int start = 0; start < cipherText.length; start += 16) {
            int remaining = Math.min(16, cipherText.length - start);
            byte[] state = Arrays.copyOfRange(cipherText, start, start + remaining);
            for (int i = 0; i < remaining; ++i) {
                int n = i;
                state[n] = (byte)(state[n] ^ roundKeys[10][i]);
            }
            for (int round = 9; round >= 0; --round) {
                byte[][] matrix = AES.loadBlock(Arrays.copyOf(state, 16));
                AES.inverseShiftRows(matrix);
                state = AES.unloadBlock(matrix);
                state = AES.inverseSubBytes(state);
                for (int i = 0; i < remaining; ++i) {
                    int n = i;
                    state[n] = (byte)(state[n] ^ roundKeys[round][i]);
                }
                if (round == 0) continue;
                matrix = AES.loadBlock(Arrays.copyOf(state, 16));
                AES.inverseMixColumns(matrix);
                state = AES.unloadBlock(matrix);
            }
            System.arraycopy(state, 0, plainText, start, remaining);
        }
        return AES.removePadding(plainText);
    }

    private static byte[] addPadding(byte[] data) {
        int padLen = 16 - data.length % 16;
        byte[] paddedData = new byte[data.length + padLen];
        System.arraycopy(data, 0, paddedData, 0, data.length);
        for (int i = data.length; i < paddedData.length; ++i) {
            paddedData[i] = (byte)padLen;
        }
        return paddedData;
    }

    private static byte[] removePadding(byte[] paddedData) {
        byte padLen = paddedData[paddedData.length - 1];
        if (padLen < 1 || padLen > 16) {
            throw new RuntimeException("Invalid AES padding length: " + padLen);
        }
        return Arrays.copyOfRange(paddedData, 0, paddedData.length - padLen);
    }

    private static byte[] subBytes(byte[] state) {
        byte[] result = new byte[state.length];
        for (int i = 0; i < state.length; ++i) {
            result[i] = AES.getSbox(state[i] & 0xFF);
        }
        return result;
    }

    private static byte[] inverseSubBytes(byte[] state) {
        byte[] result = new byte[state.length];
        for (int i = 0; i < state.length; ++i) {
            result[i] = AES.getInverseSbox(state[i] & 0xFF);
        }
        return result;
    }

    private static void shiftRows(byte[][] matrix) {
        for (int i = 1; i < 4; ++i) {
            for (int j = 0; j < i; ++j) {
                matrix[i] = AES.rotWord(matrix[i]);
            }
        }
    }

    private static void inverseShiftRows(byte[][] matrix) {
        for (int i = 1; i < 4; ++i) {
            for (int j = 0; j < i; ++j) {
                matrix[i] = AES.intRotWord(matrix[i]);
            }
        }
    }

    private static byte[] rotWord(byte[] word) {
        return new byte[]{word[1], word[2], word[3], word[0]};
    }

    private static byte[] intRotWord(byte[] word) {
        return new byte[]{word[3], word[0], word[1], word[2]};
    }

    private static void mixColumns(byte[][] state) {
        for (int c = 0; c < 4; ++c) {
            byte a0 = state[0][c];
            byte a1 = state[1][c];
            byte a2 = state[2][c];
            byte a3 = state[3][c];
            state[0][c] = (byte)(AES.multiply((byte)2, a0) ^ AES.multiply((byte)3, a1) ^ a2 ^ a3);
            state[1][c] = (byte)(a0 ^ AES.multiply((byte)2, a1) ^ AES.multiply((byte)3, a2) ^ a3);
            state[2][c] = (byte)(a0 ^ a1 ^ AES.multiply((byte)2, a2) ^ AES.multiply((byte)3, a3));
            state[3][c] = (byte)(AES.multiply((byte)3, a0) ^ a1 ^ a2 ^ AES.multiply((byte)2, a3));
        }
    }

    private static void inverseMixColumns(byte[][] state) {
        byte[] a = new byte[4];
        for (int c = 0; c < 4; ++c) {
            for (int i = 0; i < 4; ++i) {
                a[i] = state[i][c];
            }
            state[0][c] = (byte)(AES.galoisMultiply(a[0], 14) ^ AES.galoisMultiply(a[3], 9) ^ AES.galoisMultiply(a[2], 13) ^ AES.galoisMultiply(a[1], 11));
            state[1][c] = (byte)(AES.galoisMultiply(a[1], 14) ^ AES.galoisMultiply(a[0], 9) ^ AES.galoisMultiply(a[3], 13) ^ AES.galoisMultiply(a[2], 11));
            state[2][c] = (byte)(AES.galoisMultiply(a[2], 14) ^ AES.galoisMultiply(a[1], 9) ^ AES.galoisMultiply(a[0], 13) ^ AES.galoisMultiply(a[3], 11));
            state[3][c] = (byte)(AES.galoisMultiply(a[3], 14) ^ AES.galoisMultiply(a[2], 9) ^ AES.galoisMultiply(a[1], 13) ^ AES.galoisMultiply(a[0], 11));
        }
    }

    private static byte multiply(byte a, byte b) {
        int result = 0;
        int x = a & 0xFF;
        int y = b & 0xFF;
        for (int i = 0; i < 8; ++i) {
            if ((y & 1) != 0) {
                result ^= x;
            }
            boolean carry = (x & 0x80) != 0;
            x = x << 1 & 0xFF;
            if (carry) {
                x ^= 0x1B;
            }
            y >>= 1;
        }
        return (byte)(result & 0xFF);
    }

    private static byte galoisMultiply(int a, int b) {
        int p = 0;
        for (int i = 0; i < 8; ++i) {
            if ((b & 1) != 0) {
                p ^= a;
            }
            boolean carry = (a & 0x80) != 0;
            a = a << 1 & 0xFF;
            if (carry) {
                a ^= 0x1B;
            }
            b >>= 1;
        }
        return (byte)p;
    }

    public static byte[][] loadBlock(byte[] data) {
        byte[][] block = new byte[4][4];
        int idx = 0;
        for (int c = 0; c < 4; ++c) {
            for (int r = 0; r < 4; ++r) {
                block[r][c] = data[idx++];
            }
        }
        return block;
    }

    private static byte[] unloadBlock(byte[][] matrix) {
        byte[] data = new byte[16];
        int idx = 0;
        for (int c = 0; c < 4; ++c) {
            for (int r = 0; r < 4; ++r) {
                data[idx++] = matrix[r][c];
            }
        }
        return data;
    }

    private static byte getSbox(int index) {
        int[] sBox = new int[]{99, 124, 119, 123, 242, 107, 111, 197, 48, 1, 103, 43, 254, 215, 171, 118, 202, 130, 201, 125, 250, 89, 71, 240, 173, 212, 162, 175, 156, 164, 114, 192, 183, 253, 147, 38, 54, 63, 247, 204, 52, 165, 229, 241, 113, 216, 49, 21, 4, 199, 35, 195, 24, 150, 5, 154, 7, 18, 128, 226, 235, 39, 178, 117, 9, 131, 44, 26, 27, 110, 90, 160, 82, 59, 214, 179, 41, 227, 47, 132, 83, 209, 0, 237, 32, 252, 177, 91, 106, 203, 190, 57, 74, 76, 88, 207, 208, 239, 170, 251, 67, 77, 51, 133, 69, 249, 2, 127, 80, 60, 159, 168, 81, 163, 64, 143, 146, 157, 56, 245, 188, 182, 218, 33, 16, 255, 243, 210, 205, 12, 19, 236, 95, 151, 68, 23, 196, 167, 126, 61, 100, 93, 25, 115, 96, 129, 79, 220, 34, 42, 144, 136, 70, 238, 184, 20, 222, 94, 11, 219, 224, 50, 58, 10, 73, 6, 36, 92, 194, 211, 172, 98, 145, 149, 228, 121, 231, 200, 55, 109, 141, 213, 78, 169, 108, 86, 244, 234, 101, 122, 174, 8, 186, 120, 37, 46, 28, 166, 180, 198, 232, 221, 116, 31, 75, 189, 139, 138, 112, 62, 181, 102, 72, 3, 246, 14, 97, 53, 87, 185, 134, 193, 29, 158, 225, 248, 152, 17, 105, 217, 142, 148, 155, 30, 135, 233, 206, 85, 40, 223, 140, 161, 137, 13, 191, 230, 66, 104, 65, 153, 45, 15, 176, 84, 187, 22};
        return (byte)sBox[index];
    }

    private static byte getInverseSbox(int index) {
        int[] invSBox = new int[]{82, 9, 106, 213, 48, 54, 165, 56, 191, 64, 163, 158, 129, 243, 215, 251, 124, 227, 57, 130, 155, 47, 255, 135, 52, 142, 67, 68, 196, 222, 233, 203, 84, 123, 148, 50, 166, 194, 35, 61, 238, 76, 149, 11, 66, 250, 195, 78, 8, 46, 161, 102, 40, 217, 36, 178, 118, 91, 162, 73, 109, 139, 209, 37, 114, 248, 246, 100, 134, 104, 152, 22, 212, 164, 92, 204, 93, 101, 182, 146, 108, 112, 72, 80, 253, 237, 185, 218, 94, 21, 70, 87, 167, 141, 157, 132, 144, 216, 171, 0, 140, 188, 211, 10, 247, 228, 88, 5, 184, 179, 69, 6, 208, 44, 30, 143, 202, 63, 15, 2, 193, 175, 189, 3, 1, 19, 138, 107, 58, 145, 17, 65, 79, 103, 220, 234, 151, 242, 207, 206, 240, 180, 230, 115, 150, 172, 116, 34, 231, 173, 53, 133, 226, 249, 55, 232, 28, 117, 223, 110, 71, 241, 26, 113, 29, 41, 197, 137, 111, 183, 98, 14, 170, 24, 190, 27, 252, 86, 62, 75, 198, 210, 121, 32, 154, 219, 192, 254, 120, 205, 90, 244, 31, 221, 168, 51, 136, 7, 199, 49, 177, 18, 16, 89, 39, 128, 236, 95, 96, 81, 127, 169, 25, 181, 74, 13, 45, 229, 122, 159, 147, 201, 156, 239, 160, 224, 59, 77, 174, 42, 245, 176, 200, 235, 187, 60, 131, 83, 153, 97, 23, 43, 4, 126, 186, 119, 214, 38, 225, 105, 20, 99, 85, 33, 12, 125};
        return (byte)invSBox[index];
    }
}

