/**
 * Phase 1 : Can you break in? Good luck!
 * <p>
 * Authors:	Hussein Al-Ani, Abiral Pokharel
 * Course:	COMP 4290
 * Assignment:	Project 3 Phase 1
 * Date:	11/14/2025
 */

import java.util.*;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class Alani1 {
    public static void main(String[] args) {
        List<String> usernames = Arrays.asList("alani1", "garantche2", "guest", "hinkle5", "kent4", "perez10", "rheyne1", "toure3", "wittman1");

        HashMap<String, String> passwords = new HashMap<String, String>();
        HashMap<String, String> secrets = new HashMap<String, String>();
        HashMap<String, Integer> success = new HashMap<String, Integer>();
        HashMap<String, Integer> failure = new HashMap<String, Integer>();

        //manually setting password for 9 users
        passwords.put("alani1", "lLPp8eDQADOrR/pMMHHChYWduhw=");
        passwords.put("garantche2", "qHlTDLXSTFh3Hrh3w505FZ4n1rA=");
        passwords.put("guest", "W6ph5Mm5Pz8GgiULbPgzG37mj9g=");
        passwords.put("hinkle5", "Kbgwvpe2KkDdXVSbmHduzW5Fs0A=");
        passwords.put("kent4", "m+yfWFLBiG6JVathdlpioeiabcY=");
        passwords.put("perez10", "ij92wp2if/xxK8Q8J4PHcN+e/QY=");
        passwords.put("rheyne1", "uDGSMQFGxOL9Ta3t/1MX7gdcPc4=");
        passwords.put("toure3", "ARA7Vdd1AbWJ3EkpqAnBwbZTxbE=");
        passwords.put("wittman1", "RPFOioG3nCBmppXYLJO0exWRAes=");

        //manually setting secret message
        //if you are hacking, then this is encrypted secret message
        secrets.put("alani1", "sMhlVSPMAR6kdt5G8S+eAfJDGMUEyzVeGOXGkyMf9bAVcBICy0rpI96ilYPjGFhd");
        secrets.put("garantche2", "DezgS9AGJ4oyDQvYMTK851hillMEd0G4bmZcuWbBzMQLYkwBg/vbeJxFFxr9IQMu");
        secrets.put("guest", "e4ZxuNsrStWWTH8eEDsQnGObLFkNfd6RfVeX7ndirLw=");
        secrets.put("hinkle5", "51l1HGasMaLEMf2iacFBPrxp/5EVa9EifCNSnlhG1twjYuw0sfVKsX90AKwj3mg0");
        secrets.put("kent4", "MRZ0O3weyRzaBgpZ783ReJq8236lIV6GkcZKe8RAFL/wEliW3Huchx0bspSTk09Z");
        secrets.put("perez10", "q2DyiIAMsxKKjqFd9BiulVzPLcgm4CkMxIsSWDC0BBLwxjdHOYhYubOdbjp0TCj3S1tjpCGiVMxLfKCVr5WrLA==");
        secrets.put("rheyne1", "fQYqwecVICech2OD82VCOoCED4vzoVeae5KcTfED9dw=");
        secrets.put("toure3", "QrGIaZXneBf3RLtW6gCr0fWOrBodI4kAxZRq7Vyhk7E3/4qJas+V0I+Ow/hksr9L");
        secrets.put("wittman1", "qIm1wHweqEwxwUAgoIIJPDRfESB3Cg0QlT+YvvWQhHw=");


        //set initial success and failure to 0
        for (String username : usernames) {
            success.put(username, 0);
            failure.put(username, 0);

        }

        Scanner in = new Scanner(System.in);
        boolean quit = false;
        //the menu
        while (!quit) {
            //menu
            System.out.println("Menu:");
            System.out.println("\t1. Login");
            System.out.println("\t2. List Users");
            System.out.println("\t3. Quit");
            System.out.print("Enter Command: ");
            String command = in.next();
            if (command.equals("3")) {
                quit = true;
            } else {
                if (command.equals("1")) {
                    // gets user name and password
                    System.out.print("Enter user name: ");
                    String username = in.next();
                    System.out.print("Enter password: ");
                    String password = in.next();
                    //test username and password
                    String hashedPassword = Base64.getEncoder().encodeToString(MAIN_SHA1.process(MAIN_SHA1.pad(password.getBytes())));
                    String userPassword = passwords.get(username);
                    if (userPassword != null && userPassword.equals(hashedPassword)) {
                        byte[] passByte = password.getBytes(); //get og password
                        byte[] paddedPassByte = AES.padding(passByte);
                        byte[] aesKey = new byte[16];
                        System.arraycopy(paddedPassByte, 0, aesKey, 0, 16);
                        AES aes = new AES(aesKey);
                        byte[] secretMessage = Base64.getDecoder().decode(secrets.get(username));
                        byte[] decrypted = aes.unpadAndDecrypt(secretMessage);
                        String decryptedMessage = new String(decrypted, StandardCharsets.UTF_8);
                        System.out.println("The secret message is: " + decryptedMessage);
                        int successCount = success.get(username) + 1;
                        success.put(username, successCount);
                    } else {
                        if (userPassword != null) {
                            // increment the successful and unsuccessful attempt for each user here
                            int failureCount = failure.get(username) + 1;
                            failure.put(username, failureCount);
                            System.out.println("Unsuccessful Login attempt! ");
                        }
                    }
                } else if (command.equals("2")) {
                    //listusers
                    System.out.printf("%-20s %-20s %-20s\n", "User", "Successful Logins", "Unsuccessful Logins");
                    System.out.println("-----------------------------------------------------------------------");

                    for (String username : usernames) {
                        System.out.printf("%-20s %-20d %-20d\n", username, success.get(username), failure.get(username));
                    }

                } else {
                    System.out.println("Invalid Command, Try Again!");
                }
            }

        }


    }

}


class MAIN_SHA1 {
    public static byte[] pad(byte[] password) {
        if (password.length > 55) {
            byte[] processedPassword = new byte[55];
            System.arraycopy(password, 0, processedPassword, 0, 55);
            password = processedPassword;
        }
        int length = password.length;
        long passwordBitLength = (long) length * 8;
        //multiple of 64
        int pad = (64 - ((length + 8 + 1) % 64)) % 64;
        int totalLength = length + 1 + pad + 8;
        byte[] padded = Arrays.copyOf(password, totalLength);

        //add 1 at start
        padded[length] = (byte) 0x80;

        //added later
        for (int i = 0; i < 8; i++) {
            padded[padded.length - 1 - i] = (byte) (passwordBitLength >>> (8 * i));
        }
        return padded;

    }

    public static byte[] process(byte[] password) {
        //these are hash constants
        int h0 = 0x67452301;
        int h1 = 0xEFCDAB89;
        int h2 = 0x98BADCFE;
        int h3 = 0x10325476;
        int h4 = 0xC3D2E1F0;
        //round constants for 80 rounds
        final int k1 = 0x5A827999; //round 0 to 19
        final int k2 = 0x6ED9EBA1; //round 20 to 39
        final int k3 = 0x8F1BBCDC; //round 40 to 59
        final int k4 = 0xCA62C1D6; //round 60 to 79
        int[] w = new int[80];
        for (int i = 0; i < password.length / 4; i++) { // divide by 8 or 4
            w[i] = (password[i * 4] & 0xFF) << 24 | (password[(i * 4) + 1] & 0xFF) << 16 | (password[(i * 4) + 2] & 0xFF) << 8 | (password[(i * 4) + 3] & 0xFF);
        }
        //message schedule
        for (int i = 16; i < 80; i++) {
            w[i] = Integer.rotateLeft(w[i - 3] ^ w[i - 8] ^ w[i - 14] ^ w[i - 16], 1);
        }

        int a = h0;
        int b = h1;
        int c = h2;
        int d = h3;
        int e = h4;

        int f = 0;
        int k = 0;
        //main loop
        for (int i = 0; i < 80; i++) {
            if (i >= 0 && i <= 19) {
                f = (b & c) | ((~b) & d);
                k = k1;
            } else if (i >= 20 && i <= 39) {
                f = b ^ c ^ d;
                k = k2;
            } else if (i >= 40 && i <= 59) {
                f = (b & c) | (b & d) | (c & d);
                k = k3;
            } else if (i >= 60 && i <= 79) {
                f = b ^ c ^ d;
                k = k4;
            }
            int temp = Integer.rotateLeft(a, 5) + f + e + k + w[i];
            e = d;
            d = c;
            c = Integer.rotateLeft(b, 30);
            b = a;
            a = temp;

        }
        h0 = h0 + a;
        h1 = h1 + b;
        h2 = h2 + c;
        h3 = h3 + d;
        h4 = h4 + e;

        byte[] digest = new byte[20];
        int[] h = {h0, h1, h2, h3, h4};
        for (int i = 0; i < h.length; i++) {
            int hValue = h[i];
            digest[i * 4] = (byte) (hValue >>> 24);
            digest[i * 4 + 1] = (byte) (hValue >>> 16);
            digest[i * 4 + 2] = (byte) (hValue >>> 8);
            digest[i * 4 + 3] = (byte) (hValue);
        }
        return digest;
    }
}